// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

var event_mgr = require("event_mgr");
import HttpManager from 'HttpManager';
var tools = {
    playerIndex : 0,
    init: function()
    {
        cc.log("tools init")
        this.getAllLimitessLevelCfg();
        this.getAllStageCfg();
        this.getAllSkillCfg();
    },

    getPlayerIndex: function()
    {
        this.playerIndex++;
        return this.playerIndex;
    },
    
    
    getRandomNumber: function(min, max)
    {
        if(arguments.length == 1)
        {
            return parseInt(Math.random()*min + 1, 10);
        }
        else
        {
            return parseInt(Math.random()*(max - min + 1) + min, 10);
        }
    },

    getRandomIdByWeight: function(idArray, weightArray)
    {
        if(idArray.length != weightArray.length)
        {
            cc.error("error:  idArray length  != weightArray length");
            return;
        }

        var totalWeight = 0;
        for(let i = 0; i < weightArray.length; i++)
        {
            totalWeight += weightArray[i];
        }
        let randomWeight = this.getRandomNumber(totalWeight);
        var targetIndex = 0;
        var tempWeight = 0;
        for(let i = 0; i < weightArray.length; i++)
        {
            tempWeight += weightArray[i];
            if(randomWeight <= tempWeight)
            {
                targetIndex = i;
                break;
            }
        }
        return idArray[targetIndex];
    },

    getRandomIdByWeightNoId: function(idArray, weightArray, id)
    {
        // return 0;
        if(idArray.length != weightArray.length)
        {
            cc.error("error:  idArray length  != weightArray length");
            return;
        }

        var idIndex = idArray.indexOf(id);
        if(idIndex != -1)
        {
            idArray.splice(idIndex, 1);
            weightArray.splice(idIndex, 1);
        }
        
        var totalWeight = 0;
        for(let i = 0; i < weightArray.length; i++)
        {
            totalWeight += weightArray[i];
        }
        let randomWeight = this.getRandomNumber(totalWeight);
        var targetIndex = 0;
        var tempWeight = 0;
        for(let i = 0; i < weightArray.length; i++)
        {
            tempWeight += weightArray[i];
            if(randomWeight <= tempWeight)
            {
                targetIndex = i;
                break;
            }
        }
        return idArray[targetIndex];
    },


    /* --------------------- 统计信息 ------------------------*/
    getShowGuideState: function()
    {
        var key = "guideInfo";
        var state = cc.sys.localStorage.getItem(key);
        if(state == null || state == "")
        {
            state = "1";
            cc.sys.localStorage.setItem(key, state);
            return true;
        }
        return false;
    },

    // getCurSkill: function() //获取当前使用的玩家技能
    // {
    //     var key = "curSkill";
    //     var skillId = cc.sys.localStorage.getItem(key);
    //     if(skillId == null || skillId == "")
    //     {
    //         skillId = 4;
    //         if(cc.sys.platform == cc.sys.WECHAT_GAME)
    //         {
    //         }
    //         cc.sys.localStorage.setItem(key, skillId)
    //     }
    //     return Number(skillId);
    // },

    // setCurSkill: function(skillId)
    // {
    //     var key = "curSkill";
    //     cc.sys.localStorage.setItem(key, skillId)
    // },

    upSkillLevel: function(skillId)
    {
        var key = "skillLv" + skillId;
        var skillLv = this.getSkillLevel(skillId)
        let skillCfg = this.getGoodsConfgById(skillId);
        var costGold = skillLv * skillCfg.price;
        costGold = parseInt(costGold);
        cc.log("upskillLevel: addGold:", costGold);
        this.addGold(-costGold);
        
        skillLv = skillLv + 1;
        cc.sys.localStorage.setItem(key, skillLv)
        return skillLv;
    },

    setSkillLv: function(id, lv)
    {
        var key = "skillLv" + id;
        cc.sys.localStorage.setItem(key, lv);
    },

    getSkillLevel: function(skillId)
    {
        var key = "skillLv" + skillId;
        var skillLv = cc.sys.localStorage.getItem(key);
        if(skillLv == null || skillLv == "")
        {
            skillLv = 1;
            if(cc.sys.platform == cc.sys.WECHAT_GAME)
            {
            }
            cc.sys.localStorage.setItem(key, skillLv)
        }
        return Number(skillLv);
    },

    saveStageRecord: function(stageId)
    {
        var curStageId = Number(stageId);
        let highest = this.getStageRecord();
        if(curStageId > highest)
        {
            cc.sys.localStorage.setItem("new_stage_record", curStageId)
            if(cc.sys.platform == cc.sys.WECHAT_GAME)
            {
                // this.saveRecordToServer(distance);
                tools.saveDataToServer();
            }
        }
    },

    getStageRecord: function()
    {
        var key = "new_stage_record";
        var highest = cc.sys.localStorage.getItem(key);
        if(highest == null || highest == "")
        {
            highest = 0;
            if(cc.sys.platform == cc.sys.WECHAT_GAME)
            {
            }
            cc.sys.localStorage.setItem(key, highest)
        }
        return Number(highest);
    },

    getStageStarRecord: function(stageId)
    {
        var key = "stage_star_record"+stageId;
        var highest = cc.sys.localStorage.getItem(key);
        if(highest == null || highest == "")
        {
            highest = 0;
            if(cc.sys.platform == cc.sys.WECHAT_GAME)
            {
            }
            cc.sys.localStorage.setItem(key, highest)
        }
        return Number(highest);
    },

    getCurSkin:function()
    {
        var key = "cur_skin_name";
        var skinName = cc.sys.localStorage.getItem(key);
        if(skinName == null || skinName == "")
        {
            skinName = "skin1";
            this.setCurSkin(skinName);
        }
        return skinName;
    },

    setCurSkin: function(skinName)
    {
        cc.sys.localStorage.setItem("cur_skin_name", skinName)
    },

    // 体力值
    getPower: function(){
        var key = "power_keyString";
        var powerInfo = cc.sys.localStorage.getItem(key);
        if(powerInfo == null || powerInfo == "")
        {
            this.setPower(5, 0);
        }
        powerInfo = cc.sys.localStorage.getItem(key);
        powerInfo = JSON.parse(powerInfo);
        cc.log("getPower:", powerInfo)
        var data = new Date();
        let curTime = data.getTime();
        let oldCurTime = powerInfo.curTime;
        let recoverTime = powerInfo.recoverTime;
        cc.log("old recoverTime:", recoverTime)
        var delTime = curTime - oldCurTime;
        delTime = Math.floor(delTime/1000);
        cc.log("delTime:", delTime)
        powerInfo.curTime = curTime;
        if(powerInfo.power < 5)
        {
            if(delTime < recoverTime)
            {
                powerInfo.recoverTime = recoverTime - delTime;
            }
            else
            {
                powerInfo.power = powerInfo.power == 5 ? 5 : powerInfo.power + 1;
                delTime = delTime - recoverTime;
                let addPower = Math.floor(delTime / 1800);
                let temprecoverTime = delTime % 1800;
                if (powerInfo.power + addPower >= 5) {
                    cc.log("getPower2:")
                    powerInfo.power = 5;
                    powerInfo.recoverTime = 0;
                }
                else {
                    powerInfo.power = powerInfo.power + addPower;
                    powerInfo.recoverTime = 1800 - temprecoverTime;
                    cc.log("getPower3:", powerInfo, delTime, addPower, temprecoverTime)
                }
            }
        }
        let savePowerInfo = JSON.stringify(powerInfo);
        var key = "power_keyString";
        cc.sys.localStorage.setItem(key, savePowerInfo)
        return powerInfo;
    },

    
    setPower: function(power, recoverTime)
    {
        // cc.log("setPower")
        var data = new Date();
        let newPowerInfo = {
            power: power,
            curTime : data.getTime(),
            recoverTime: recoverTime,
        }
        cc.log("setPower:", newPowerInfo);
        let powerInfo = JSON.stringify(newPowerInfo);
        var key = "power_keyString";
        cc.sys.localStorage.setItem(key, powerInfo)
        event_mgr.dispatch_event("power_Change");
    },

    addPower: function(power, limit)
    {
        var key = "power_keyString";
        var powerInfo = cc.sys.localStorage.getItem(key);
        powerInfo = JSON.parse(powerInfo);
        var data = new Date();
        let curTime = data.getTime();
        cc.log("addPower:", powerInfo.power, power)
        powerInfo.power = powerInfo.power + power;
        powerInfo.curTime = curTime;
        if(powerInfo.power >= 5)
        {
            if(limit)
            {
                powerInfo.power = 5;
            }
            powerInfo.recoverTime = 0;
        }
        else if(power < 0 && powerInfo.recoverTime == 0)
        {
            powerInfo.recoverTime = 1800;
        }
        cc.log("addPower1:", powerInfo.power)
        let powerInfoStr = JSON.stringify(powerInfo);
        var key = "power_keyString";
        cc.sys.localStorage.setItem(key, powerInfoStr)
        event_mgr.dispatch_event("power_Change");
    },

    formatTimeToString: function(second)
    {
        var min = Math.floor(second/60);
        if(min < 10)
        {
            min = "0" + min.toString() 
        }
        else
        {
            min = min.toString();
        }
        let sec = second%60;
        if(sec < 10)
        {
            sec = "0" + sec.toString() 
        }
        else
        {
            sec = sec.toString();
        }
        return min + " : " + sec;
    },

    //金币
    getGoodsNum: function(goodsId)
    {
        var key = "goods_num_"+ goodsId;
        var goodsNum = cc.sys.localStorage.getItem(key);
        if(goodsNum == null || goodsNum == "")
        {
            goodsNum = 0;
            if(goodsId == 10)//默认皮肤默认拥有
            {
                goodsNum = 1;
            }
            cc.sys.localStorage.setItem(key, goodsNum)
        }
        return parseInt(goodsNum);
    },


    addGoodsNum(goodsId)
    {
        var key = "goods_num_"+ goodsId;
        var goodsNum = this.getGoodsNum(goodsId);
        goodsNum = goodsNum+1;
        cc.sys.localStorage.setItem(key, goodsNum)
    },

    setGoodsNum(goodsId, num)
    {
        var key = "goods_num_"+ goodsId;
        cc.sys.localStorage.setItem(key, num)
    },

    reduceGoodsNum(goodsId)
    {
        var key = "goods_num_"+ goodsId;
        var goodsNum = this.getGoodsNum(goodsId);
        goodsNum = goodsNum-1;
        if(goodsNum <= 0)
        {
            goodsNum = 0;
        }
        cc.sys.localStorage.setItem(key, goodsNum)
    },

    addGold: function(num) //返回能不能购买
    {
        var goldNum = this.getGold();

        goldNum = goldNum+num;
        if(goldNum < 0)
        {
            return false;
        }
        cc.sys.localStorage.setItem("gold_num", goldNum);
        event_mgr.dispatch_event("gold_Change", num);
        return true;
    },

    getGold: function()
    {
        var goldNum = cc.sys.localStorage.getItem("gold_num");
        if(goldNum == null || goldNum == "")
        {
            goldNum = 500000;
            cc.sys.localStorage.setItem("gold_num", goldNum)
        }
        return parseInt(goldNum);
    },

    addDiamond: function(num) //返回能不能购买
    {
        var diamondNum = this.getDiamond();

        diamondNum = diamondNum+num;
        if(diamondNum < 0)
        {
            return false;
        }
        cc.sys.localStorage.setItem("diamond_num", diamondNum);
        event_mgr.dispatch_event("diamond_Change", num);
        return true;
    },

    getDiamond: function()
    {
        var diamondNum = cc.sys.localStorage.getItem("diamond_num");
        if(diamondNum == null || diamondNum == "")
        {
            diamondNum = 10000;
            cc.sys.localStorage.setItem("diamond_num", diamondNum)
        }
        return parseInt(diamondNum);
    },

    getLuckTimes: function()
    {
        var date = new Date();
        var today = date.getDate();
        var oldDay = cc.sys.localStorage.getItem("LuckDay");
        var times = cc.sys.localStorage.getItem("LuckTimes");
        if(oldDay == null || oldDay == "")
        {
            cc.sys.localStorage.setItem("LuckDay", today);
            cc.sys.localStorage.setItem("LuckTimes", 1);
        }
        else if(Number(oldDay) != today)
        {
            cc.sys.localStorage.setItem("LuckDay", today);
            cc.sys.localStorage.setItem("LuckTimes", 1);
        }
        return cc.sys.localStorage.getItem("LuckTimes");
    },

    reduceLuckTimes: function()
    {
        var times = cc.sys.localStorage.getItem("LuckTimes");
        if(times > 0)
        {
            cc.sys.localStorage.setItem("LuckTimes",  times - 1);
        }
    },

    getTodaySignDays: function()//已经签到多少天
    {
        var times = cc.sys.localStorage.getItem("signTimes");
        if(times == null || times == "")
        {
            cc.sys.localStorage.setItem("signTimes",  0);
            times = 0;
        }
        return Number(times);
    },

    getTodaySignState: function()//今天签到状态
    {
        var date = new Date();
        var today = date.getDate();
        var month = date.getMonth();

        var oldMonth = cc.sys.localStorage.getItem("oldSignMonth");
        var oldDay = cc.sys.localStorage.getItem("oldSignDay");
        if(oldMonth == null || oldMonth == "")
        {
            cc.sys.localStorage.setItem("oldSignMonth",  0);
            cc.sys.localStorage.setItem("oldSignDay",  0);
            oldMonth = cc.sys.localStorage.getItem("oldSignMonth");
            oldDay = cc.sys.localStorage.getItem("oldSignDay");
        }
        if(oldMonth == month && oldDay == today)
        {
            return true;
        }
        else
        {
            return false;
        }
    },

    sign: function()
    {
        var date = new Date();
        var today = date.getDate();
        var month = date.getMonth();
        cc.sys.localStorage.setItem("oldSignMonth",  month);
        cc.sys.localStorage.setItem("oldSignDay",  today);
        cc.sys.localStorage.setItem("signTimes",  this.getTodaySignDays() + 1);
    },

    getWatchAdTimes: function(type)//今天广告钻石获得了多少次
    {
        var key = "get" + type + "WatchAdTimes";
        var times = cc.sys.localStorage.getItem(key);
        if(times == null || times == "")
        {
            cc.sys.localStorage.setItem(key,  0);
            times = 0;
        }
        return Number(times);
    },

    WatchAd: function(type)
    {
        var dayKey = "old" + type + "WatchAdDay";
        var timesKey = "get" + type + "WatchAdTimes";
        var date = new Date();
        var today = date.getDate()
        var oldDay = cc.sys.localStorage.getItem(dayKey);
        if(oldDay == null || oldDay == "")
        {
            cc.sys.localStorage.setItem(dayKey,  0);
            oldDay = cc.sys.localStorage.getItem(dayKey);
        }
        var times = cc.sys.localStorage.getItem(timesKey);
        if(oldDay == today)
        {
            times++
        }
        else
        {
            times = 0;
            cc.sys.localStorage.setItem(dayKey,  today);
        }
        cc.sys.localStorage.setItem(timesKey,  times);
    },

    saveRecord: function(distance)
    {
        cc.log("saveRecord:function:", distance);
        let highest = this.getHighestRecord();
        cc.log("saveRecord:function:", highest);
        // this.saveRecordToServer(distance);
        if(distance > highest)
        {
            cc.sys.localStorage.setItem("highest_record", distance)
            if(cc.sys.platform == cc.sys.WECHAT_GAME)
            {
                console.log("saveRecord:", distance)
                this.saveRecordToServer(distance);
                tools.saveDataToServer();
            }
        }
    },
    
    getHighestRecord: function()
    {
        cc.log("getHighestRecord")
        var highest = cc.sys.localStorage.getItem("highest_record");
        if(highest == null || highest == "")
        {
            highest = 0;
            console.log("== getHighestRecord == ")
            if(cc.sys.platform == cc.sys.WECHAT_GAME)
            {
                console.log("== getHighestRecord == ")
                this.saveRecordToServer(0);
            }
            cc.sys.localStorage.setItem("highest_record", highest)
        }
        return highest;
    },

    getCurDataToServer: function()
    {
        let gold = this.getGold(); //金币，
        let distance = this.getHighestRecord();//最远纪录
        var goodsMap = {};//物品道具信息
        for(let i = 0; i < cc.vv.json.shop.length; i++)
        {
            goodsMap[String(cc.vv.json.shop[i].id)] = this.getGoodsNum(cc.vv.json.shop[i].id);
        }
        let curSkin = this.getCurSkin();//当前使用的皮肤
        //技能等级信息
        var skillInfo = {};
        skillInfo.skillLv = {};
        for(let i = 0; i < this.skillCfgArray.length; i++)
        {
            skillInfo.skillLv[String(this.skillCfgArray[i].id)] = this.getSkillLevel(this.skillCfgArray[i].id);
        }

        //关卡信息{当前关卡，每关星数，}
        
        var stageRecord = this.getStageRecord();
        var signInfo = {
            signtimes : cc.sys.localStorage.getItem("signTimes"),
            oldMonth : cc.sys.localStorage.getItem("oldSignMonth"),
            oldDay : cc.sys.localStorage.getItem("oldSignDay"),
        }
        //
        var data = {
            gold: gold,
            distance: distance,
            goodsInfo: goodsMap,
            curSkin: curSkin,
            skillInfo: skillInfo,
            stageRecord: stageRecord,
            signInfo: signInfo,
        };
        
        var result = Base64.encode(JSON.stringify(data)); 
        return result;
    },

    setCurDataFromServer: function(data)
    {
        if(data == null)
        {
            return;
        }
        else
        {
            var decodeData = Base64.decode(data);
            var curData = JSON.parse(decodeData);
            cc.sys.localStorage.setItem("gold_num", curData.gold);
            this.saveRecord(curData.distance);
            Object.keys(curData.goodsInfo).forEach(function(key){
                this.setGoodsNum(key, curData.goodsInfo.key);
            }.bind(this));
            this.setCurSkin(curData.curSkin);
            Object.keys(curData.skillInfo).forEach(function(key){
                this.setskillLv(key, curData.skillInfo.key);
            }.bind(this));
            this.saveStageRecord(curData.stageRecord);
            cc.sys.localStorage.setItem("signTimes", curData.signtimes);
            cc.sys.localStorage.setItem("oldSignMonth", curData.oldMonth);
            cc.sys.localStorage.setItem("oldSignDay", curData.oldDay);
        }
    },

    saveRecordToServer: function(distance)
    {
        console.log("saveRecordToServer: function", distance)
        this.setRank(1, cc.vv.Player.userId, cc.vv.Player.name, distance, this.getCurSkin(), cc.vv.Player.avatarUrl, false);
        this.setRank(2, cc.vv.Player.userId, cc.vv.Player.name, tools.getStageRecord(), this.getCurSkin(), cc.vv.Player.avatarUrl, false);
        wx.setUserCloudStorage({ //上传分数到微信
            KVDataList: [{
                key: "score",
                value: String(distance)
            },
            {
                key: "maxStage",
                value: String(this.getStageRecord())
            },
            {
                key: "skin",
                value: this.getCurSkin()
            }
            ],

            success: function (res) {
                console.log("upload success");
            },

            fail: function (res) {
                console.log("upload fail");
            },
        });
    },

    saveDataToServer: function()
    {
        cc.log("=== saveDataToServer ====")
        if (cc.sys.platform === cc.sys.WECHAT_GAME) {
            let serverUrl = "https://botali.zjwinturn.com/GameRankServer/"
            let url = serverUrl + "GameRank_savePlayerData";
            wx.request({
                url: url,
                data: {
                    game: "runMan",
                    userId: cc.vv.Player.userId,
                    diamond: 0,
                    data: this.getCurDataToServer(),
                },
                success: function(res) {
                    console.log("saveDataToServer success")
                }.bind(this),
                fail(res) {
                    console.log("saveDataToServer fail")
                },
            })
        } 
    },

    getMusicOpenState: function()
    {
        var highest = cc.sys.localStorage.getItem("music_state");
        if(highest == null || highest == "")
        {
            highest = 1;
            cc.sys.localStorage.setItem("music_state", highest)
        }
        return highest;
    },

    changeMusicOpenState: function(openState)
    {
        cc.sys.localStorage.setItem("music_state", openState)
    },
    /* ---------------------统计信息 end ------------------------*/

    /* --------------------- 配置表信息 ------------------------*/
    

    getAllSkillCfg: function()
    {
        this.skillCfgArray = [];
        for(let i = 0; i < cc.vv.json.shop.length; i++)
        {
            if(cc.vv.json.shop[i].type != 2)
            {
                this.skillCfgArray.push(cc.vv.json.shop[i]);
            }
        }
    },

    getNextStageId : function(stageId)
    {
        return stageId + 1;
    },
    getAllStageCfg : function()
    {
        this.allStageCfgArray = [];
        for (let i = 0; i < cc.vv.json.level.length; i++) {
            if(cc.vv.json.level[i].id > 999)
            {
                this.allStageCfgArray.push(cc.vv.json.level[i]);
            }
        }
    },

    getAllLimitessLevelCfg : function()
    {
        this.allLimitessLevelCfgArray = [];
        for (let i = 0; i < cc.vv.json.level.length; i++) {
            if(cc.vv.json.level[i].id < 1000)
            {
                this.allLimitessLevelCfgArray.push(cc.vv.json.level[i]);
            }
        }
        
    },

    getMapConfgById: function(id)
    {
        for (let i = 0; i < cc.vv.json.map.length; i++) {
            if(cc.vv.json.map[i].difficulty == id)
            {
                return cc.vv.json.map[i];
            }
        }
        cc.error("config error : json not find!!  id:",id);
        return null;
    },

    getMapIdByDiff: function(diff) // 通过难度获得地图id
    {
        var mapCfg = this.getMapConfgById(diff);
        var mapIdArray = this.formatNumberConfigListToArray(mapCfg.map);
        var index = tools.getRandomNumber(1, mapIdArray.length);
        return mapIdArray[index - 1];
    },

    getStageConfigById: function(id)
    {
        for (let i = 0; i < cc.vv.json.stage.length; i++) {
            if(id <= cc.vv.json.stage[i].id)
            {
                return cc.vv.json.stage[i];
            }
        }
        return cc.vv.json.stage[cc.vv.json.stage.length -1];
    },

    getLevelConfgById: function(id)
    {
        for (let i = 0; i < cc.vv.json.level.length; i++) {
            if(cc.vv.json.level[i].id == id)
            {
                return cc.vv.json.level[i];
            }
        }
        cc.error("config error : level not find!!  id:",id);
        return null;
    },

    getStringByKey: function(key)
    {
        for (let i = 0; i < cc.vv.json.string.length; i++) {
            if(cc.vv.json.string[i].key == key)
            {
                if(cc.vv.gameDef.lauguage == "CN")
                {
                    return cc.vv.json.string[i].cn;
                }
                else
                {
                    return cc.vv.json.string[i].en;
                }
            }
        }
        return "";
    },

    getLimitlessMaxLevelCfg: function()//无尽关卡最大id
    {
        return this.allLimitessLevelCfgArray[this.allLimitessLevelCfgArray.length - 1];
    },

    getStageWinDistanceById: function(id)
    {
        var distanceArray = [];
        var stageCfg = this.getLevelConfgById(id);
        var mapArray = this.formatNumberConfigListToArray(stageCfg.mapId)
        var distance = cc.vv.gameDef.design_size.width*0.5;
        var winAarry = tools.formatNumberConfigListToArray(stageCfg.kijL);
        
        for(let i = 0; i < mapArray.length; i++)
        {
            distance = distance + cc.vv.mapPrefabs["map" + mapArray[i]].data.getChildByName("tiledlayer").width;
        }
        distanceArray.push(distance);
        var gameOverDistance = distance + cc.vv.gameDef.design_size.width;
        for(let i = 2; i < winAarry.length; i++)
        {
            gameOverDistance = gameOverDistance + cc.vv.mapPrefabs["map" + winAarry[i]].data.getChildByName("tiledlayer").width;
        }
        
        distanceArray.push(gameOverDistance);
        return distanceArray; //第一个是通过距离，第二个是福利关卡结束距离
    },

    getGoodsConfgById: function(id)
    {
        for (let i = 0; i < cc.vv.json.shop.length; i++) {
            if(cc.vv.json.shop[i].id == id)
            {
                return cc.vv.json.shop[i];
            }
        }
        cc.error("config error : shop not find!!  id:",id);
        return null;
    },

    getLevelIdByDistance: function(distance)
    {
        var levelId = 0;
        for (let i = 0; i < this.allLimitessLevelCfgArray.length; i++) {
            if(parseInt(this.allLimitessLevelCfgArray[i].distance) > distance)
            {
                levelId = this.allLimitessLevelCfgArray[i].id;
                break;
            }
        }
        if(levelId == 0)
        {
            levelId = this.allLimitessLevelCfgArray[this.allLimitessLevelCfgArray.length - 1].id;
        }
        return levelId;
    },

    formatNumberConfigListToArray: function(list)
    {
        var targetArray = [];
        var array = list.split(";");
        array.pop();
        for(let i = 0; i < array.length; i++)
        {
            targetArray.push(parseInt(array[i]));
        }
        return targetArray;
    },

    formatStringConfigListToArray: function(list)
    {
        var array = list.split(";");
        array.pop();
        return array;
    },


    
      /* --------------------- 配置表信息 end ------------------------*/

      //排行榜微信
    setRank: function setRank(type, open_id, name, score, skin, param1, lastUpdate) {
        cc.log("setRank. openId:", open_id);
        var params = {
            "game": "runMan",
            "rank_type": type,
            "open_id": open_id,
            "name": name,
            "score": score,
            "param": skin,
            "param1": param1,
            "session": window.sessionkey
        };
        var paramsStr = "";
        var keys = new Array("game", "rank_type", "open_id", "name", "score", "param", "param1");
        keys.sort();
        for (var i = 0; i < keys.length; i++) {
            paramsStr += keys[i] + "=" + tools.urlencode(params[keys[i]]);
            if (i != keys.length - 1)
                paramsStr += "&";
        }
        // paramsStr = encodeURI(paramsStr);
        var sign = tools.hex_md5(paramsStr);
        paramsStr = paramsStr + "&sign=" + sign;
        let callback = function (err, ret) {
            if (err) {
                // log_error(err)
                return
            }
            let responseJson = JSON.parse(ret);
            if (!responseJson.d) return
            let d = JSON.parse(responseJson.d.replace(/\'/g, "\""))
            window.myWorldRankInfo = {
                ranking: parseInt(d.ranking),
                score: parseInt(d.score),
            }
            if (lastUpdate) {
                gg.Player.rankLastOver = window.myWorldRankInfo.ranking
            }
        }
        let serverUrl = "https://botali.zjwinturn.com/GameRankServer/"
        HttpManager.getInstance().get(serverUrl, "GameRank_setRank", paramsStr, callback)

    },
      // 将字符串格式化为UTF8编码的字节
    urlencode(clearString) {
        var output = '';
        var x = 0;

        clearString = utf16to8(clearString.toString());
        var regex = /(^[a-zA-Z0-9-_.]*)/;

        while (x < clearString.length) {
            var match = regex.exec(clearString.substr(x));
            if (match != null && match.length > 1 && match[1] != '') {
                output += match[1];
                x += match[1].length;
            }
            else {
                if (clearString[x] == ' ')
                    output += '+';
                else {
                    var charCode = clearString.charCodeAt(x);
                    var hexVal = charCode.toString(16);
                    output += '%' + (hexVal.length < 2 ? '0' : '') + hexVal.toUpperCase();
                }
                x++;
            }
        }

        function utf16to8(str) {
            var out, i, len, c;

            out = "";
            len = str.length;
            for (i = 0; i < len; i++) {
                c = str.charCodeAt(i);
                if ((c >= 0x0001) && (c <= 0x007F)) {
                    out += str.charAt(i);
                }
                else if (c > 0x07FF) {
                    out += String.fromCharCode(0xE0 | ((c >> 12) & 0x0F));
                    out += String.fromCharCode(0x80 | ((c >> 6) & 0x3F));
                    out += String.fromCharCode(0x80 | ((c >> 0) & 0x3F));
                }
                else {
                    out += String.fromCharCode(0xC0 | ((c >> 6) & 0x1F));
                    out += String.fromCharCode(0x80 | ((c >> 0) & 0x3F));
                }
            }
            return out;
        }

        return output;
    },

     /**
         * @author Rui.Zhang
         * @description 对给定数据进行 md5 摘要计算
         * @param {String} str_data  待计算的数据
         * @returns {String}, md5 计算结果
         **/
    hex_md5: function (str_data) {
            var chrsz = 8;
            /* bits per input character. 8 - ASCII; 16 - Unicode      */
            var hexcase = 0;
            /* hex output format. 0 - lowercase; 1 - uppercase        */
    
            /*
             * Convert an array of little-endian words to a base-64 string
             */
            var binl2b64 = function (binarray) {
                var tab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
                var str = "";
                for (var i = 0; i < binarray.length * 4; i += 3) {
                    var triplet = (((binarray[i >> 2] >> 8 * (i % 4)) & 0xFF) << 16)
                        | (((binarray[i + 1 >> 2] >> 8 * ((i + 1) % 4)) & 0xFF) << 8)
                        | ((binarray[i + 2 >> 2] >> 8 * ((i + 2) % 4)) & 0xFF);
                    for (var j = 0; j < 4; j++) {
                        if (i * 8 + j * 6 > binarray.length * 32) str += b64pad;
                        else str += tab.charAt((triplet >> 6 * (3 - j)) & 0x3F);
                    }
                }
                return str;
            }
    
            /*
             * These functions implement the four basic operations the algorithm uses.
             */
            var md5_cmn = function (q, a, b, x, s, t) {
                return safe_add(bit_rol(safe_add(safe_add(a, q), safe_add(x, t)), s), b);
            }
            var md5_ff = function (a, b, c, d, x, s, t) {
                return md5_cmn((b & c) | ((~b) & d), a, b, x, s, t);
            }
            var md5_gg = function (a, b, c, d, x, s, t) {
                return md5_cmn((b & d) | (c & (~d)), a, b, x, s, t);
            }
            var md5_hh = function (a, b, c, d, x, s, t) {
                return md5_cmn(b ^ c ^ d, a, b, x, s, t);
            }
            var md5_ii = function (a, b, c, d, x, s, t) {
                return md5_cmn(c ^ (b | (~d)), a, b, x, s, t);
            }
    
            /*
             * Convert an array of little-endian words to a base-64 string
             */
            var binl2b64 = function (binarray) {
                var tab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
                var str = "";
                for (var i = 0; i < binarray.length * 4; i += 3) {
                    var triplet = (((binarray[i >> 2] >> 8 * (i % 4)) & 0xFF) << 16)
                        | (((binarray[i + 1 >> 2] >> 8 * ((i + 1) % 4)) & 0xFF) << 8)
                        | ((binarray[i + 2 >> 2] >> 8 * ((i + 2) % 4)) & 0xFF);
                    for (var j = 0; j < 4; j++) {
                        if (i * 8 + j * 6 > binarray.length * 32) str += b64pad;
                        else str += tab.charAt((triplet >> 6 * (3 - j)) & 0x3F);
                    }
                }
                return str;
            }
    
            /*
             * Calculate the MD5 of an array of little-endian words, and a bit length
             */
            var core_md5 = function (x, len) {
                /* append padding */
                x[len >> 5] |= 0x80 << ((len) % 32);
                x[(((len + 64) >>> 9) << 4) + 14] = len;
    
                var a = 1732584193;
                var b = -271733879;
                var c = -1732584194;
                var d = 271733878;
    
                for (var i = 0; i < x.length; i += 16) {
                    var olda = a;
                    var oldb = b;
                    var oldc = c;
                    var oldd = d;
    
                    a = md5_ff(a, b, c, d, x[i + 0], 7, -680876936);
                    d = md5_ff(d, a, b, c, x[i + 1], 12, -389564586);
                    c = md5_ff(c, d, a, b, x[i + 2], 17, 606105819);
                    b = md5_ff(b, c, d, a, x[i + 3], 22, -1044525330);
                    a = md5_ff(a, b, c, d, x[i + 4], 7, -176418897);
                    d = md5_ff(d, a, b, c, x[i + 5], 12, 1200080426);
                    c = md5_ff(c, d, a, b, x[i + 6], 17, -1473231341);
                    b = md5_ff(b, c, d, a, x[i + 7], 22, -45705983);
                    a = md5_ff(a, b, c, d, x[i + 8], 7, 1770035416);
                    d = md5_ff(d, a, b, c, x[i + 9], 12, -1958414417);
                    c = md5_ff(c, d, a, b, x[i + 10], 17, -42063);
                    b = md5_ff(b, c, d, a, x[i + 11], 22, -1990404162);
                    a = md5_ff(a, b, c, d, x[i + 12], 7, 1804603682);
                    d = md5_ff(d, a, b, c, x[i + 13], 12, -40341101);
                    c = md5_ff(c, d, a, b, x[i + 14], 17, -1502002290);
                    b = md5_ff(b, c, d, a, x[i + 15], 22, 1236535329);
    
                    a = md5_gg(a, b, c, d, x[i + 1], 5, -165796510);
                    d = md5_gg(d, a, b, c, x[i + 6], 9, -1069501632);
                    c = md5_gg(c, d, a, b, x[i + 11], 14, 643717713);
                    b = md5_gg(b, c, d, a, x[i + 0], 20, -373897302);
                    a = md5_gg(a, b, c, d, x[i + 5], 5, -701558691);
                    d = md5_gg(d, a, b, c, x[i + 10], 9, 38016083);
                    c = md5_gg(c, d, a, b, x[i + 15], 14, -660478335);
                    b = md5_gg(b, c, d, a, x[i + 4], 20, -405537848);
                    a = md5_gg(a, b, c, d, x[i + 9], 5, 568446438);
                    d = md5_gg(d, a, b, c, x[i + 14], 9, -1019803690);
                    c = md5_gg(c, d, a, b, x[i + 3], 14, -187363961);
                    b = md5_gg(b, c, d, a, x[i + 8], 20, 1163531501);
                    a = md5_gg(a, b, c, d, x[i + 13], 5, -1444681467);
                    d = md5_gg(d, a, b, c, x[i + 2], 9, -51403784);
                    c = md5_gg(c, d, a, b, x[i + 7], 14, 1735328473);
                    b = md5_gg(b, c, d, a, x[i + 12], 20, -1926607734);
    
                    a = md5_hh(a, b, c, d, x[i + 5], 4, -378558);
                    d = md5_hh(d, a, b, c, x[i + 8], 11, -2022574463);
                    c = md5_hh(c, d, a, b, x[i + 11], 16, 1839030562);
                    b = md5_hh(b, c, d, a, x[i + 14], 23, -35309556);
                    a = md5_hh(a, b, c, d, x[i + 1], 4, -1530992060);
                    d = md5_hh(d, a, b, c, x[i + 4], 11, 1272893353);
                    c = md5_hh(c, d, a, b, x[i + 7], 16, -155497632);
                    b = md5_hh(b, c, d, a, x[i + 10], 23, -1094730640);
                    a = md5_hh(a, b, c, d, x[i + 13], 4, 681279174);
                    d = md5_hh(d, a, b, c, x[i + 0], 11, -358537222);
                    c = md5_hh(c, d, a, b, x[i + 3], 16, -722521979);
                    b = md5_hh(b, c, d, a, x[i + 6], 23, 76029189);
                    a = md5_hh(a, b, c, d, x[i + 9], 4, -640364487);
                    d = md5_hh(d, a, b, c, x[i + 12], 11, -421815835);
                    c = md5_hh(c, d, a, b, x[i + 15], 16, 530742520);
                    b = md5_hh(b, c, d, a, x[i + 2], 23, -995338651);
    
                    a = md5_ii(a, b, c, d, x[i + 0], 6, -198630844);
                    d = md5_ii(d, a, b, c, x[i + 7], 10, 1126891415);
                    c = md5_ii(c, d, a, b, x[i + 14], 15, -1416354905);
                    b = md5_ii(b, c, d, a, x[i + 5], 21, -57434055);
                    a = md5_ii(a, b, c, d, x[i + 12], 6, 1700485571);
                    d = md5_ii(d, a, b, c, x[i + 3], 10, -1894986606);
                    c = md5_ii(c, d, a, b, x[i + 10], 15, -1051523);
                    b = md5_ii(b, c, d, a, x[i + 1], 21, -2054922799);
                    a = md5_ii(a, b, c, d, x[i + 8], 6, 1873313359);
                    d = md5_ii(d, a, b, c, x[i + 15], 10, -30611744);
                    c = md5_ii(c, d, a, b, x[i + 6], 15, -1560198380);
                    b = md5_ii(b, c, d, a, x[i + 13], 21, 1309151649);
                    a = md5_ii(a, b, c, d, x[i + 4], 6, -145523070);
                    d = md5_ii(d, a, b, c, x[i + 11], 10, -1120210379);
                    c = md5_ii(c, d, a, b, x[i + 2], 15, 718787259);
                    b = md5_ii(b, c, d, a, x[i + 9], 21, -343485551);
    
                    a = safe_add(a, olda);
                    b = safe_add(b, oldb);
                    c = safe_add(c, oldc);
                    d = safe_add(d, oldd);
                }
                return Array(a, b, c, d);
            }
    
    
            /*
             * These functions implement the four basic operations the algorithm uses.
             */
            var md5_cmn = function (q, a, b, x, s, t) {
                return safe_add(bit_rol(safe_add(safe_add(a, q), safe_add(x, t)), s), b);
            }
    
            /*
             * Convert an array of little-endian words to a hex string.
             */
            var binl2hex = function (binarray) {
                var hex_tab = hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
                var str = "";
                for (var i = 0; i < binarray.length * 4; i++) {
                    str += hex_tab.charAt((binarray[i >> 2] >> ((i % 4) * 8 + 4)) & 0xF) +
                        hex_tab.charAt((binarray[i >> 2] >> ((i % 4) * 8)) & 0xF);
                }
                return str;
            }
    
            /*
             * Convert a string to an array of little-endian words
             * If chrsz is ASCII, characters >255 have their hi-byte silently ignored.
             */
            var str2binl = function (str) {
                var bin = Array();
                var mask = (1 << chrsz) - 1;
                for (var i = 0; i < str.length * chrsz; i += chrsz)
                    bin[i >> 5] |= (str.charCodeAt(i / chrsz) & mask) << (i % 32);
                return bin;
            }
    
            /*
             * Add integers, wrapping at 2^32. This uses 16-bit operations internally
             * to work around bugs in some JS interpreters.
             */
            var safe_add = function (x, y) {
                var lsw = (x & 0xFFFF) + (y & 0xFFFF);
                var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
                return (msw << 16) | (lsw & 0xFFFF);
            }
    
            /*
             * Bitwise rotate a 32-bit number to the left.
             */
            var bit_rol = function (num, cnt) {
                return (num << cnt) | (num >>> (32 - cnt));
            }
    
            return binl2hex(core_md5(str2binl(str_data), str_data.length * chrsz));
    },
}

var Base64={
    _keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
    encode:function(e){
        var t="";
        var n,r,i,s,o,u,a;
        var f=0;e=Base64._utf8_encode(e);
        while(f<e.length)
        {n=e.charCodeAt(f++);r=e.charCodeAt(f++);i=e.charCodeAt(f++);s=n>>2;o=(n&3)<<4|r>>4;u=(r&15)<<2|i>>6;a=i&63;if(isNaN(r)){u=a=64}else if(isNaN(i)){a=64}t=t+this._keyStr.charAt(s)+this._keyStr.charAt(o)+this._keyStr.charAt(u)+this._keyStr.charAt(a)}
        return t},
    decode:function(e){var t="";var n,r,i;var s,o,u,a;var f=0;e=e.replace(/[^A-Za-z0-9+/=]/g,"");while(f<e.length){s=this._keyStr.indexOf(e.charAt(f++));o=this._keyStr.indexOf(e.charAt(f++));u=this._keyStr.indexOf(e.charAt(f++));a=this._keyStr.indexOf(e.charAt(f++));n=s<<2|o>>4;r=(o&15)<<4|u>>2;i=(u&3)<<6|a;t=t+String.fromCharCode(n);if(u!=64){t=t+String.fromCharCode(r)}if(a!=64){t=t+String.fromCharCode(i)}}t=Base64._utf8_decode(t);return t},
    _utf8_encode:function(e){e=e.replace(/rn/g,"n");var t="";for(var n=0;n<e.length;n++){var r=e.charCodeAt(n);if(r<128){t+=String.fromCharCode(r)}else if(r>127&&r<2048){t+=String.fromCharCode(r>>6|192);t+=String.fromCharCode(r&63|128)}else{t+=String.fromCharCode(r>>12|224);t+=String.fromCharCode(r>>6&63|128);t+=String.fromCharCode(r&63|128)}}return t},
    _utf8_decode:function(e){var t="";var n=0;var r,c1,c2=0;while(n<e.length){r=e.charCodeAt(n);if(r<128){t+=String.fromCharCode(r);n++}else if(r>191&&r<224){c2=e.charCodeAt(n+1);t+=String.fromCharCode((r&31)<<6|c2&63);n+=2}else{c2=e.charCodeAt(n+1);c3=e.charCodeAt(n+2);t+=String.fromCharCode((r&15)<<12|(c2&63)<<6|c3&63);n+=3}}return t}
}
// Create Base64 Object

module.exports = tools;