const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Mask)
    mask: cc.Mask = null;

    @property(cc.Graphics)
    pen: cc.Graphics = null;

    @property
    cr: number = 0;

    onLoad() {
      
        //注册触摸监听事件
        this.node.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.onTouchEnd, this);
    }

    start() {

        console.log(this.mask);

        this.mask._graphics.lineWidth = 30;
        this.mask._graphics.strokeColor = cc.color(255, 0, 0, 150);
        this.mask._graphics.fillColor = cc.color(0, 255, 0, 255);    //cc.color(0, 255, 0);
        this.mask._graphics.lineJoin = cc.Graphics.LineJoin.ROUND;
        this.mask._graphics.lineCap = cc.Graphics.LineCap.ROUND;
    }

    //开始点击
    onTouchStart(event: cc.Event.EventTouch) {
        let point = event.touch.getLocation();
        point = this.node.convertToNodeSpaceAR(point);
        this.mask._graphics.moveTo(point.x, point.y);
    }

    //点击移动
    onTouchMove(event: cc.Event.EventTouch) {

        let point = event.touch.getLocation();
        point = this.node.convertToNodeSpaceAR(point);
        this.mask._graphics.lineTo(point.x, point.y);
        this.mask._graphics.stroke();
    }

    //点击结束
    onTouchEnd(event: cc.Event.EventTouch) {

    }

}
