
const {ccclass, property} = cc._decorator;

/// 控制字符串长度
function clipValue(value: number, digits: number, fraction: number) {
    let max = Math.pow( 10, digits-(fraction>0?fraction-1: fraction))
    value = value >= max? value = max - 1/Math.pow(10, fraction): value
    let src = Math.floor( value * Math.pow( 10, fraction)).toString()
    src = fraction <= 0? src: `${src.slice(0, src.length-fraction)}.${src.substr( src.length-fraction)}`
    let miss = digits - src.length
    return miss <= 0? src: Math.pow(10, digits - src.length).toString().substr(1) + src 
}

class RNumber {
    private labels: cc.Label[] = []
    private spaceY: number = 0
    private originY: number = 0
    private mdistance: number = 0 
    private bottom: number = 0
    private top: number = 0
    constructor( labels: cc.Label[], prefab: cc.Node, posx: number, originY: number, spaceY: number) {
        this.originY = originY; this.spaceY = spaceY;
        let sy = this.originY + this.spaceY
        this.bottom = this.originY - this.spaceY * 1.5;
        this.top = this.originY + this.spaceY * 1.5
        for( let idx=0; idx < 3; idx++){
            let temp = labels.length > 0? labels.pop(): cc.instantiate( prefab).getComponent(cc.Label)
            temp.node.parent = prefab.parent; 
            temp.node.x = posx; temp.node.y = sy - spaceY*idx
            this.labels.push( temp)
        }
    }

    private _isDown: boolean = false
    get isDown(){
        return this._isDown
    }

    scroll_up(dt: number){
        let delta = 0; let y = 0; let bsort = false;
        this.labels.forEach(label => {
            y = label.node.y + dt; delta = y - this.top
            label.node.y = delta > 0? ( this.bottom + delta): y
            bsort = bsort || delta > 0
        })
        bsort && this.sort()
        this.check( dt)
    }

    scroll_down( dt: number) {
        let delta = 0; let y = 0; let bsort = false;
        this.labels.forEach(label => {
            y = label.node.y - dt; 
            delta = this.bottom - y;
            label.node.y = delta > 0? ( this.top - delta): y
            bsort = bsort || delta > 0
        })
        bsort && this.sort()
        this.check( dt)
    }

    setValue( v: string, bAnime: boolean, dir: number){
        this._isDown = false
        bAnime = bAnime? v != ".": bAnime
        if( v !== this.labels[1].string){
            let idx = !bAnime? 1: 1-dir 
            this.labels[idx].string = v
            /// 总的需要移动距离
            this.mdistance = Math.abs(this.labels[idx].node.y) - this.originY
        }
        bAnime || this.complete()
    }

    private check( dt: number){
        this.mdistance -= dt
        this.mdistance <= 0 && this.complete()
    }

    private complete(){
        this.labels[0].node.y = this.top
        this.labels[1].node.y = this.originY
        this.labels[2].node.y = this.bottom
        this._isDown = true
    }

    private sort(){
        this.labels.sort( (a, b)=>{ 
            return a.node.y < b.node.y? 1: -1 
        })
    }
}

@ccclass
export default class RollNumber extends cc.Component {
    @property( cc.Label)
    prefab: cc.Label = null
    // 显示多少位 有小数要+1
    @property( cc.Integer)
    digits: number  = 1
    // number 的宽
    @property( cc.Float)
    spaceX: number = 0
    /// number 的高
    @property( cc.Float)
    spaceY: number = 0
    /// 第一个num的偏移 offsety是num 的水平位置
    @property(cc.Vec2)
    offset: cc.Vec2 = cc.Vec2.ZERO
    /// 小数点个数
    @property( cc.Integer)
    fraction: number = 0 
    /// 动画速度
    @property( cc.Float)
    animeSpeed: number = 3
    /// 当前值
    private curValue: number = 0
    /// 当前显示的数字
    private nums: RNumber[] = []
    /// 当前动画方向 direction
    private dir: number = 0 
    /// 是否都完成了动画 strvalue
    private strValue: string = ""
    private animeIdx: number = 0
    // private allDown: boolean = true

    start(){
        if( this.prefab){
            this.nums = []
            let labels = this.getComponentsInChildren( cc.Label)
            for( let idx=0; idx < this.digits; idx ++){
                let num = new RNumber( labels, this.prefab.node, this.offset.x + idx*this.spaceX, this.offset.y, this.spaceY)
                this.nums.push( num)
            }
        }
    }

    setValue( value: number, bAnime: boolean = false){
        this.dir = value > this.curValue? 1: -1;
        this.curValue = value
        this.strValue = clipValue( this.curValue, this.digits, this.fraction)
        console.log( this.strValue, value)
        this.animeIdx = this.digits - 1
        this.unschedule( this.onStartAnime)
        if( bAnime) {
            this.schedule( this.onStartAnime, 0.1, this.digits-1)
        } else {
            for( let idx=0; idx < this.digits; idx ++){
                this.nums[idx].setValue( this.strValue.charAt(idx), bAnime, this.dir)
            }
        }
    }

    onStartAnime(){
        if( this.animeIdx >= 0){
            let num = this.nums[this.animeIdx]
            let char = this.strValue.charAt( this.animeIdx)
            num.setValue( char, true, this.dir)
            this.animeIdx --
        }
    }

    update( dt: number){
        /// 分开up&down 是减少 foreach 中的if 判断
        if( this.dir < 0) {
            this.nums.forEach(num => {
                num.isDown || num.scroll_up( this.animeSpeed)
            });
        } else {
            this.nums.forEach(num => {
                num.isDown || num.scroll_down( this.animeSpeed)
            });
        }
    }
}