// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class Demo extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        this.label.node.on(cc.Node.EventType.SIZE_CHANGED, this.onLabelChange, this);
        this.label.string = "当前网络太差，请检查网络设置后重试（检查移动网络或Wi-Fi网络是否可用）";
    }

    onLabelChange() {
        if (this.label.node.width > 570) {
            this.label.node.off(cc.Node.EventType.SIZE_CHANGED, this.onLabelChange, this);
            this.label.horizontalAlign = cc.Label.HorizontalAlign.LEFT;
            this.label.overflow = cc.Label.Overflow.RESIZE_HEIGHT;
            this.label.node.width = 570;
        }
    }
}
