/**
 *zongyuan.yang 重新封装PhysicsCollider类
 */
var MyPhysicsCollider=cc.Class({
    extends: cc.PhysicsCollider,
    editor: {
        menu: CC_EDITOR && 'i18n:MAIN_MENU.component.physics/Collider/Polygon',
        // inspector: CC_EDITOR && 'packages://inspector/inspectors/comps/physics/points-base-collider.js',
        requireComponent: cc.RigidBody
    },
    properties: {
        lineWidth: 5,
        points:[cc.Vec2]
    },
    _createShape: function (scale) {
        var shapes = [];

        var polys = this.points;
        var offset = this.offset;
        console.log(polys);
        var polyIdx = 0;
        for (var i = 0; i < polys.length - 1; i++) {
            var posBegin = polys[i];
            var posEnd = polys[i+1];
            // var linelen = cc.pDistance(posBegin, posEnd);
            var linelen = posBegin.sub(posEnd).mag() ;

            // var angle = cc.pToAngle(cc.p(posEnd.x - posBegin.x, posEnd.y - posBegin.y)) - Math.PI / 2;
            var angle=Math.atan2(posEnd.y - posBegin.y, posEnd.x - posBegin.x)- Math.PI / 2;

            // var midPos = cc.pMidpoint(posBegin, posEnd);  p1.add(p2).mul(0.5)
            var midPos =  posBegin.add(posEnd).mul(0.5);

            var shape = new b2.PolygonShape();

            if (shape) {
                shape.SetAsOrientedBox(this.lineWidth / 2 / 32, linelen / 2 / 32, new b2.Vec2(midPos.x / 32, midPos.y / 32), angle);
                shapes.push(shape);
            }
        }

        return shapes;
    }
});

module.exports = MyPhysicsCollider;