const {ccclass, property} = cc._decorator;
import MyPhysicsCollider = require("./MyPhysicsCollider")
@ccclass
export  class MainContro extends cc.Component {
    private graphics:cc.Graphics=null;
    private rigibodyLogic: cc.RigidBody = null;
    private line_point: cc.Vec2[] = [];
    private physicsLine=null;

    onLoad () {

        this.graphics=this.getComponent(cc.Graphics);

        var manager:cc.PhysicsManager = cc.director.getPhysicsManager();
        manager.enabled = true;
        manager.debugDrawFlags  = 1;


        this.node.on(cc.Node.EventType.TOUCH_START,this.touch_start,this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE,this.touch_move,this);
        this.node.on(cc.Node.EventType.TOUCH_END,this.touch_end,this);


    }
    start() {

    }
    /**
     * 触摸开始
     * @param {cc.Event} event
     */
    private touch_start(event:cc.Event.EventTouch):void{
        this.line_point=[];
        let pos:cc.Vec2=this.node.convertToNodeSpaceAR(event.getLocation());
        this.graphics.moveTo(pos.x,pos.y);
        this.line_point.push(cc.v2(pos.x,pos.y));
    }
    /**移动开始
     * @param {cc.Event} event
     */
    private touch_move(event:cc.Event.EventTouch):void{
        let pos:cc.Vec2=this.node.convertToNodeSpaceAR(event.getLocation());
        this.graphics.lineTo(pos.x,pos.y);
        this.line_point.push(cc.v2(pos.x,pos.y));
        this.graphics.stroke();


        // let lastTouchLoc = this.line_point[this.line_point.length - 1];
        // if (this.checkIsCanDraw(lastTouchLoc, pos)) {
        //     // 射线检测
        //     let result = cc.director.getPhysicsManager().rayCast(lastTouchLoc, pos, cc.RayCastType.All);
        //     if (result.length <= 0) {
        //         this.line_point.push(cc.p(pos.x, pos.y));
        //         this.graphics.lineTo(pos.x, pos.y);
        //         // this.path.moveTo(touchLoc.x, touchLoc.y);
        //         this.graphics.stroke();
        //     } else {
        //         this.graphics.clear();
        //         this.graphics.moveTo(lastTouchLoc.x, lastTouchLoc.y);
        //         this.graphics.lineTo(pos.x, pos.y);
        //         this.graphics.stroke();
        //     }
        //
        // }

    } /**
     * 触摸结束
     * @param {cc.Event} event  cc.PhysicsCollider
     */
    private touch_end(event:cc.Event.EventTouch):void{
        this.createRigibody();
    }
    /**
     * 创建刚体
     * @param {number} dt
     */
    private createRigibody():void{
        console.log(this.line_point);
        this.rigibodyLogic = this.addComponent(cc.RigidBody);
        this.physicsLine = this.addComponent("MyPhysicsCollider");
        this.physicsLine.lineWidth = this.graphics.lineWidth;
        this.physicsLine.points = this.line_point;
        this.physicsLine.apply();

    }
    checkIsCanDraw(lastPoint: cc.Vec2, nowPoint: cc.Vec2) {
        // return cc.pDistance(lastPoint, nowPoint) >= 20;  p1.sub(p2).mag()
        return lastPoint.sub(nowPoint).mag() >= 20;
    }


    update (dt) {

    }
}
