cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function () {
        let nodeCanvas = cc.find("Canvas");
        nodeCanvas.on(cc.Node.EventType.TOUCH_START.toString(), this.onTouchBegan.bind(this));

        this.label.string = this.text;

        
        
        

    },

    onTouchBegan(event) {
        // 点击nodeMap上的一点，比如双眼中间下部的黑色尖尖，，此时nodeMap.convertTouchToNodeSpaceAR得到的坐标是posInMap
        // 设置摄像机跟随主角
        // 然后再次点击屏幕上吉祥物双眼下方的黑色尖尖，nodeMap.convertTouchToNodeSpaceAR得到的posInMap，却不是原来的posInMap
        let touchInScreen = event.getTouches()[0];
        let nodeMap = cc.find("Canvas/map");

        let nodeHero1 = cc.find("Canvas/map/hero1");
        let posInMap = nodeMap.convertTouchToNodeSpaceAR(touchInScreen);
        nodeHero1.position = posInMap;

        cc.log(posInMap);
    },

    // called every frame
    update: function (dt) {
        let nodeHero1 = cc.find("Canvas/map/hero1");
        let nodeCamera = cc.find("Canvas/camera");
        let targetPos = nodeHero1.convertToWorldSpaceAR(cc.Vec2.ZERO);
        nodeCamera.position = nodeCamera.parent.convertToNodeSpaceAR(targetPos);
    },
});
