// Learn TypeScript:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class DyLabel extends cc.Component {

    private m_labels: Array<cc.Label> = [];

    onLoad() {
        this.node.children.forEach((node:cc.Node) => {
            this.m_labels.push(node.getComponent(cc.Label));
        })
    }

    start() {
        
    }

    setText(str: string) {
        this.setString(str);
    }

    setString(str: string) {
        this.m_labels.forEach((label: cc.Label) => {
            label.string = str;
        })
        this.doAnimate();
    }

    // 播放动画
    private doAnimate() {
        this.getComponent(cc.Animation).playAdditive('douyingAni');
    }



    // update (dt) {}
}
