
const { ccclass, property } = cc._decorator;

@ccclass
export default class DebugResourceUI extends cc.Component {
    @property(cc.Node)
    private item: cc.Node = undefined;
    @property(cc.Node)
    private content: cc.Node = undefined;
    @property(cc.Label)
    private label: cc.Label = undefined;

    // 当页面被关闭
    public close() {
        this.content.removeAllChildren();
        this.node.active = false;
    }

    public async init() {
        this.content.on("touchend", () => {
            this.close();
        }, this);
    }

    // 当页面被打开
    public open() {
        let cache = cc.loader["_cache"];
        let keys: string[] = Object.keys(cache);

        let textureCount: number = 0;
        let totalBytes: number = 0;
        let offsetY: number = 50;
        let height = offsetY;

        for (let i = 0, len = keys.length; i < len; i++) {
            let url = keys[i];
            let o = cache[url];
            if (o.content && cc.js.getClassName(o.content) == "cc.Texture2D") {
                let texture2D: cc.Texture2D = o.content;
                textureCount++;
                let newItem = cc.instantiate(this.item);
                newItem.active = true;
                let sprite = newItem.getComponent<cc.Sprite>(cc.Sprite);
                sprite.spriteFrame = new cc.SpriteFrame(texture2D);
                newItem.setParent(this.content);
                newItem.x = 0;
                newItem.y = - height - offsetY;
                newItem.scale = 0.8; 
                height += newItem.height * 0.8 + 30;

                let bytes = texture2D.width * texture2D.height * 4;       // rgba
                totalBytes += bytes;
                let m = bytes/ (1024.0 * 1024.0);
                newItem.getComponentInChildren<cc.Label>(cc.Label).string = m.toFixed(4) + "M";
            }
            this.content.height = height;
        }

        let textureMemoryInfo: string = "纹理数量 " + textureCount + " 纹理内存 " + (totalBytes / (1024.0 * 1024.0)).toFixed(4) + " M";
        this.label.string = textureMemoryInfo;
    }
}
