local proto = [[
#
# sproto 协议
# 包括客户端协议和服务端协议
#
  .package {
    type 0 : integer
    session 1 : integer
  }

  # 房间配置信息
  .RoomConfig {
    game_id 0: integer
    game_name 1: string
    min_player_num 2 : integer
    max_player_num 3 : integer
    max_watcher_num 4 : integer
    max_round 5 : integer
    join_in_playing 6 : integer
    ai_tick_interval 7 : integer

    show_card_timeout 8 : integer
    response_card_timeout 9: integer
    next_round_timeout 10: integer
    decks_num 11 : integer
    need_room_card 12: integer
  }


  # 用户信息
  .User {
    id 0: integer
    type 1: integer
    phone 2: string
    nickname 3: string
    avatar 4: string
    avatar_id 5: integer
    gender 6: integer
    level 7: integer
    diamonds 8: integer
    gold 9: integer
    room_card 10: integer
    vip 11: integer
    exp 12: integer
    last_login_at 13: string
  }

  # 房间信息
  .Room {
    room_id 0: integer
    room_code 1: string
    creator_uid 2: integer
    seat_uids 3: *integer   ##数组[uid,uid,uid]
    watcher_uids 4: *integer ##数组[uid,uid,uid]
    players 5: *User ##存储所有的用户，{uid: user对象}
    config 6: RoomConfig
  }

  # 响应牌组
  .Response_Card {
    type 0: integer
    cards 1: *integer
  }

  # 玩家的牌
  .Round_Player_Cards {
    uid 0: integer
    left_cards 1: *integer ## 剩余的牌
    shown_cards 2: *integer ## 已经出过的牌
    responsed_cards 3: *Response_Card ## 已经响应过的牌(如吃、碰、杠过的牌等)
  }


  .Round  {
    round_id 1: integer
    room_id 2: integer
    master_uid 3: integer

    seat_uids 4: integer
    watcher_uids 5: integer ##观察玩家
    status 6: string ##当前状态 详见  game_status.lua
    players_cards 7: *Round_Player_Cards    #桌面的牌  object 【uid: Round_Player_Cards,】
  }





#
# 客户端消息
# 协议编号从 1 开始
# 客户端协议名称不能使用 server_ 开头
#
room_create 1 {
  request {
    config 0: RoomConfig
  }
  response {
    code 0: integer
    code_str 1: string
    cmd 2: string
    room 3: Room  ## *表示是数组 不加 *表示对像
  }
}

room_join 2 {
  request {
    room_code 0: string
  }
  response {
    code 0: integer
    code_str 1: string
    room 2: Room
  }
}

room_player_ready 3 {
  request {
    room_id 0: string
  }
  response {
    code 0: integer
    code_str 1: string
  }
}

room_game_status 4 {
  request {
    room_id 0: string
  }
  response {
    code 0 : integer
    code_str 1: string
    round 2 : Round
  }
}

room_game_action 5 {
  request {
    type 0 : integer ## 动作类型，具体参照对应游戏的action_type.lua
    param 1 : *string ## 每个动作对应不同的param 比如如果type=0，那么param就存储下注的金额
    index 2 : integer ##
  }
  response {
    code 0: integer
    code_str 1: string
    type 2 : integer
    param 3 : *string
    index 4 : integer
  }
}

#
# 服务端消息
# 协议编号从 1001 开始
# 服务端协议名称 都使用 server_ 开头
#

server_room_join 1001 {
  request {
    user 0: User
    seat 1: integer
  }
}

server_player_ready 1002 {
  request {
    uid 0: integer
  }
}

server_game_ready 1003 {
  request {
    round 0: Round
  }
}

server_game_action 1004 {
  request {
    type 0: integer
    pos 1: integer
    param 2: *string
  }
}



]]


return proto
