const { ccclass, property } = cc._decorator;

@ccclass
export default class RTT extends cc.Component {

    @property(cc.Node)
    text: cc.Node = null;

    @property(cc.Sprite)
    spr: cc.Sprite = null;

    private myRT: cc.RenderTexture = null;
    private cameraRT: cc.RenderTexture = null;
    private camera: cc.Camera = null;

    onLoad() {
        this.myRT = new cc.RenderTexture();
        this.myRT.setFilters(cc.Texture2D.Filter.LINEAR, cc.Texture2D.Filter.LINEAR);
        this.myRT.initWithSize(1136, 640);

        this.spr.spriteFrame = new cc.SpriteFrame(this.myRT);
        this.camera = cc.find('Canvas/Main Camera').getComponent(cc.Camera);
        this.camera.backgroundColor = this.camera.backgroundColor.clone().setA(0);
        this.cameraRT = this.camera.targetTexture;
    }

    lateUpdate() {
        let c = this.camera;
        c.backgroundColor.setA(0);
        c.targetTexture = this.myRT;
        c.render(this.text);
        c.targetTexture = this.cameraRT;
        c.backgroundColor.setA(255);
    }

}
