const {ccclass, property} = cc._decorator;

@ccclass
export default class Main extends cc.Component {

    private textureAssetCache:cc.Texture2D = null;

    protected start ():void {
        cc.resources.load('Texture',cc.Texture2D,this.onTextureLoaded.bind(this));
    }

    private onTextureLoaded(error:Error,asset:cc.Texture2D):void{
        this.textureAssetCache = asset;
        asset.addRef();
        cc.log('On Texture Loaded, Ref Count = '+this.textureAssetCache.refCount);
        cc.resources.load('Texture',cc.SpriteFrame,this.onSpriteFrameLoaded.bind(this));
    }

    private onSpriteFrameLoaded(error:Error,asset:cc.SpriteFrame):void{
        asset.addRef();
        cc.log('On Sprite Frame Loaded, Ref Count = '+this.textureAssetCache.refCount);
        cc.resources.load('TestB',cc.Prefab,this.onPrefabBLoaded.bind(this));
    }

    private onPrefabBLoaded(error:Error,asset:cc.SpriteFrame):void{
        asset.addRef();
        cc.log('On Prefab B Loaded, Ref Count = '+this.textureAssetCache.refCount);
        cc.resources.load('TestC',cc.Prefab,this.onPrefabCLoaded.bind(this));
    }

    private onPrefabCLoaded(error:Error,asset:cc.SpriteFrame):void{
        asset.addRef();
        cc.log('On Prefab C Loaded, Ref Count = '+this.textureAssetCache.refCount);
    }

}
