
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__qc_index__.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}
require('./i18n-plugin/LanguageData');
require('./i18n-plugin/LocalizedLabel');
require('./i18n-plugin/LocalizedSprite');
require('./i18n-plugin/SpriteFrameSet');
require('./i18n-plugin/polyglot.min');
require('./assets/Script/Base/FitScene');
require('./assets/Script/Test3d');

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/i18n-plugin/LocalizedLabel.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '744dcs4DCdNprNhG0xwq6FK', 'LocalizedLabel');
// LocalizedLabel.js

"use strict";

var i18n = require('LanguageData'); // Returns a function, that, as long as it continues to be invoked, will not
// be triggered. The function will be called after it stops being called for
// N milliseconds. If `immediate` is passed, trigger the function on the
// leading edge, instead of the trailing.


function debounce(func, wait, immediate) {
  var timeout;
  return function () {
    var context = this,
        args = arguments;

    var later = function later() {
      timeout = null;
      if (!immediate) func.apply(context, args);
    };

    var callNow = immediate && !timeout;
    clearTimeout(timeout);
    timeout = setTimeout(later, wait);
    if (callNow) func.apply(context, args);
  };
}

cc.Class({
  "extends": cc.Component,
  editor: {
    executeInEditMode: true,
    menu: 'i18n/LocalizedLabel'
  },
  properties: {
    dataID: {
      get: function get() {
        return this._dataID;
      },
      set: function set(val) {
        if (this._dataID !== val) {
          this._dataID = val;

          if (CC_EDITOR) {
            this._debouncedUpdateLabel();
          } else {
            this.updateLabel();
          }
        }
      }
    },
    _dataID: ''
  },
  onLoad: function onLoad() {
    if (CC_EDITOR) {
      this._debouncedUpdateLabel = debounce(this.updateLabel, 200);
    }

    if (!i18n.inst) {
      i18n.init();
    } // cc.log('dataID: ' + this.dataID + ' value: ' + i18n.t(this.dataID));


    this.fetchRender();
  },
  fetchRender: function fetchRender() {
    var label = this.getComponent(cc.Label);

    if (label) {
      this.label = label;
      this.updateLabel();
      return;
    }
  },
  updateLabel: function updateLabel() {
    if (!this.label) {
      cc.error('Failed to update localized label, label component is invalid!');
      return;
    }

    var localizedString = i18n.t(this.dataID);

    if (localizedString) {
      this.label.string = i18n.t(this.dataID);
    }
  }
});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/i18n-plugin/polyglot.min.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'e26fd9yy65A4q3/JkpVnFYg', 'polyglot.min');
// polyglot.min.js

"use strict";

//     (c) 2012 Airbnb, Inc.
//
//     polyglot.js may be freely distributed under the terms of the BSD
//     license. For all licensing information, details, and documention:
//     http://airbnb.github.com/polyglot.js
//
//
// Polyglot.js is an I18n helper library written in JavaScript, made to
// work both in the browser and in Node. It provides a simple solution for
// interpolation and pluralization, based off of Airbnb's
// experience adding I18n functionality to its Backbone.js and Node apps.
//
// Polylglot is agnostic to your translation backend. It doesn't perform any
// translation; it simply gives you a way to manage translated phrases from
// your client- or server-side JavaScript application.
//
(function (e, t) {
  typeof define == "function" && define.amd ? define([], function () {
    return t(e);
  }) : typeof exports == "object" ? module.exports = t(e) : e.Polyglot = t(e);
})(void 0, function (e) {
  "use strict";

  function t(e) {
    e = e || {}, this.phrases = {}, this.extend(e.phrases || {}), this.currentLocale = e.locale || "en", this.allowMissing = !!e.allowMissing, this.warn = e.warn || c;
  }

  function s(e) {
    var t,
        n,
        r,
        i = {};

    for (t in e) {
      if (e.hasOwnProperty(t)) {
        n = e[t];

        for (r in n) {
          i[n[r]] = t;
        }
      }
    }

    return i;
  }

  function o(e) {
    var t = /^\s+|\s+$/g;
    return e.replace(t, "");
  }

  function u(e, t, r) {
    var i, s, u;
    return r != null && e ? (s = e.split(n), u = s[f(t, r)] || s[0], i = o(u)) : i = e, i;
  }

  function a(e) {
    var t = s(i);
    return t[e] || t.en;
  }

  function f(e, t) {
    return r[a(e)](t);
  }

  function l(e, t) {
    for (var n in t) {
      n !== "_" && t.hasOwnProperty(n) && (e = e.replace(new RegExp("%\\{" + n + "\\}", "g"), t[n]));
    }

    return e;
  }

  function c(t) {
    e.console && e.console.warn && e.console.warn("WARNING: " + t);
  }

  function h(e) {
    var t = {};

    for (var n in e) {
      t[n] = e[n];
    }

    return t;
  }

  t.VERSION = "0.4.3", t.prototype.locale = function (e) {
    return e && (this.currentLocale = e), this.currentLocale;
  }, t.prototype.extend = function (e, t) {
    var n;

    for (var r in e) {
      e.hasOwnProperty(r) && (n = e[r], t && (r = t + "." + r), typeof n == "object" ? this.extend(n, r) : this.phrases[r] = n);
    }
  }, t.prototype.clear = function () {
    this.phrases = {};
  }, t.prototype.replace = function (e) {
    this.clear(), this.extend(e);
  }, t.prototype.t = function (e, t) {
    var n, r;
    return t = t == null ? {} : t, typeof t == "number" && (t = {
      smart_count: t
    }), typeof this.phrases[e] == "string" ? n = this.phrases[e] : typeof t._ == "string" ? n = t._ : this.allowMissing ? n = e : (this.warn('Missing translation for key: "' + e + '"'), r = e), typeof n == "string" && (t = h(t), r = u(n, this.currentLocale, t.smart_count), r = l(r, t)), r;
  }, t.prototype.has = function (e) {
    return e in this.phrases;
  };
  var n = "||||",
      r = {
    chinese: function chinese(e) {
      return 0;
    },
    german: function german(e) {
      return e !== 1 ? 1 : 0;
    },
    french: function french(e) {
      return e > 1 ? 1 : 0;
    },
    russian: function russian(e) {
      return e % 10 === 1 && e % 100 !== 11 ? 0 : e % 10 >= 2 && e % 10 <= 4 && (e % 100 < 10 || e % 100 >= 20) ? 1 : 2;
    },
    czech: function czech(e) {
      return e === 1 ? 0 : e >= 2 && e <= 4 ? 1 : 2;
    },
    polish: function polish(e) {
      return e === 1 ? 0 : e % 10 >= 2 && e % 10 <= 4 && (e % 100 < 10 || e % 100 >= 20) ? 1 : 2;
    },
    icelandic: function icelandic(e) {
      return e % 10 !== 1 || e % 100 === 11 ? 1 : 0;
    }
  },
      i = {
    chinese: ["fa", "id", "ja", "ko", "lo", "ms", "th", "tr", "zh"],
    german: ["da", "de", "en", "es", "fi", "el", "he", "hu", "it", "nl", "no", "pt", "sv"],
    french: ["fr", "tl", "pt-br"],
    russian: ["hr", "ru"],
    czech: ["cs"],
    polish: ["pl"],
    icelandic: ["is"]
  };
  return t;
});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/i18n-plugin/LocalizedSprite.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'f34ac2GGiVOBbG6XlfvgYP4', 'LocalizedSprite');
// LocalizedSprite.js

"use strict";

var SpriteFrameSet = require('SpriteFrameSet');

cc.Class({
  "extends": cc.Component,
  editor: {
    executeInEditMode: true,
    inspector: 'packages://i18n/inspector/localized-sprite.js',
    menu: 'i18n/LocalizedSprite'
  },
  properties: {
    spriteFrameSet: {
      "default": [],
      type: SpriteFrameSet
    }
  },
  onLoad: function onLoad() {
    this.fetchRender();
  },
  fetchRender: function fetchRender() {
    var sprite = this.getComponent(cc.Sprite);

    if (sprite) {
      this.sprite = sprite;
      this.updateSprite(window.i18n.curLang);
      return;
    }
  },
  getSpriteFrameByLang: function getSpriteFrameByLang(lang) {
    for (var i = 0; i < this.spriteFrameSet.length; ++i) {
      if (this.spriteFrameSet[i].language === lang) {
        return this.spriteFrameSet[i].spriteFrame;
      }
    }
  },
  updateSprite: function updateSprite(language) {
    if (!this.sprite) {
      cc.error('Failed to update localized sprite, sprite component is invalid!');
      return;
    }

    var spriteFrame = this.getSpriteFrameByLang(language);

    if (!spriteFrame && this.spriteFrameSet[0]) {
      spriteFrame = this.spriteFrameSet[0].spriteFrame;
    }

    this.sprite.spriteFrame = spriteFrame;
  }
});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/i18n-plugin/SpriteFrameSet.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '97019Q80jpE2Yfz4zbuCZBq', 'SpriteFrameSet');
// SpriteFrameSet.js

"use strict";

var SpriteFrameSet = cc.Class({
  name: 'SpriteFrameSet',
  properties: {
    language: '',
    spriteFrame: cc.SpriteFrame
  }
});
module.exports = SpriteFrameSet;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uXFwuQ29jb3NDcmVhdG9yXFxwYWNrYWdlc1xcaTE4blxccnVudGltZS1zY3JpcHRzXFxTcHJpdGVGcmFtZVNldC5qcyJdLCJuYW1lcyI6WyJTcHJpdGVGcmFtZVNldCIsImNjIiwiQ2xhc3MiLCJuYW1lIiwicHJvcGVydGllcyIsImxhbmd1YWdlIiwic3ByaXRlRnJhbWUiLCJTcHJpdGVGcmFtZSIsIm1vZHVsZSIsImV4cG9ydHMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBQUEsSUFBTUEsY0FBYyxHQUFHQyxFQUFFLENBQUNDLEtBQUgsQ0FBUztBQUM1QkMsRUFBQUEsSUFBSSxFQUFFLGdCQURzQjtBQUU1QkMsRUFBQUEsVUFBVSxFQUFFO0FBQ1JDLElBQUFBLFFBQVEsRUFBRSxFQURGO0FBRVJDLElBQUFBLFdBQVcsRUFBRUwsRUFBRSxDQUFDTTtBQUZSO0FBRmdCLENBQVQsQ0FBdkI7QUFRQUMsTUFBTSxDQUFDQyxPQUFQLEdBQWlCVCxjQUFqQiIsInNvdXJjZVJvb3QiOiIvIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgU3ByaXRlRnJhbWVTZXQgPSBjYy5DbGFzcyh7XHJcbiAgICBuYW1lOiAnU3ByaXRlRnJhbWVTZXQnLFxyXG4gICAgcHJvcGVydGllczoge1xyXG4gICAgICAgIGxhbmd1YWdlOiAnJyxcclxuICAgICAgICBzcHJpdGVGcmFtZTogY2MuU3ByaXRlRnJhbWVcclxuICAgIH1cclxufSk7XHJcblxyXG5tb2R1bGUuZXhwb3J0cyA9IFNwcml0ZUZyYW1lU2V0OyJdfQ==
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/i18n-plugin/LanguageData.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '61de062n4dJ7ZM9/Xdumozn', 'LanguageData');
// LanguageData.js

"use strict";

var Polyglot = require('polyglot.min');

var polyInst = null;

if (!window.i18n) {
  window.i18n = {
    languages: {},
    curLang: ''
  };
}

if (CC_EDITOR) {
  Editor.Profile.load('profile://project/i18n.json', function (err, profile) {
    window.i18n.curLang = profile.data['default_language'];

    if (polyInst) {
      var data = loadLanguageData(window.i18n.curLang) || {};
      initPolyglot(data);
    }
  });
}

function loadLanguageData(language) {
  return window.i18n.languages[language];
}

function initPolyglot(data) {
  if (data) {
    if (polyInst) {
      polyInst.replace(data);
    } else {
      polyInst = new Polyglot({
        phrases: data,
        allowMissing: true
      });
    }
  }
}

module.exports = {
  /**
   * This method allow you to switch language during runtime, language argument should be the same as your data file name
   * such as when language is 'zh', it will load your 'zh.js' data source.
   * @method init
   * @param language - the language specific data file name, such as 'zh' to load 'zh.js'
   */
  init: function init(language) {
    if (language === window.i18n.curLang) {
      return;
    }

    var data = loadLanguageData(language) || {};
    window.i18n.curLang = language;
    initPolyglot(data);
    this.inst = polyInst;
  },

  /**
   * this method takes a text key as input, and return the localized string
   * Please read https://github.com/airbnb/polyglot.js for details
   * @method t
   * @return {String} localized string
   * @example
   *
   * var myText = i18n.t('MY_TEXT_KEY');
   *
   * // if your data source is defined as
   * // {"hello_name": "Hello, %{name}"}
   * // you can use the following to interpolate the text
   * var greetingText = i18n.t('hello_name', {name: 'nantas'}); // Hello, nantas
   */
  t: function t(key, opt) {
    if (polyInst) {
      return polyInst.t(key, opt);
    }
  },
  inst: polyInst,
  updateSceneRenderers: function updateSceneRenderers() {
    // very costly iterations
    var rootNodes = cc.director.getScene().children; // walk all nodes with localize label and update

    var allLocalizedLabels = [];

    for (var i = 0; i < rootNodes.length; ++i) {
      var labels = rootNodes[i].getComponentsInChildren('LocalizedLabel');
      Array.prototype.push.apply(allLocalizedLabels, labels);
    }

    for (var _i = 0; _i < allLocalizedLabels.length; ++_i) {
      var label = allLocalizedLabels[_i];
      if (!label.node.active) continue;
      label.updateLabel();
    } // walk all nodes with localize sprite and update


    var allLocalizedSprites = [];

    for (var _i2 = 0; _i2 < rootNodes.length; ++_i2) {
      var sprites = rootNodes[_i2].getComponentsInChildren('LocalizedSprite');

      Array.prototype.push.apply(allLocalizedSprites, sprites);
    }

    for (var _i3 = 0; _i3 < allLocalizedSprites.length; ++_i3) {
      var sprite = allLocalizedSprites[_i3];
      if (!sprite.node.active) continue;
      sprite.updateSprite(window.i18n.curLang);
    }
  }
};

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Test3d.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '33b50ijJQVMXZifJfylB4SR', 'Test3d');
// Script/Test3d.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
// import Global from "./Global";
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Test3d = /** @class */ (function (_super) {
    __extends(Test3d, _super);
    function Test3d() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.coin = null;
        _this.pushs = [];
        _this._poolCoin = new cc.NodePool();
        _this._coins = new Set();
        return _this;
    }
    Test3d.prototype.genCoin = function () {
        for (var i = 0; i < 1; i++) {
            this.createCoin();
        }
    };
    Test3d.prototype.createCoin = function () {
        var node;
        if (this._poolCoin.size() > 0) {
            node = this._poolCoin.get();
        }
        else {
            node = cc.instantiate(this.coin);
        }
        this._coins.add(node);
        node.x = Math.random() * 6 - 3;
        node.y = Math.random() * 2 + 2;
        node.z = Math.random() * 6 - 3;
        node.active = true;
        node.parent = this.coin.parent;
    };
    Test3d.prototype.onLoad = function () {
        // super.onLoad()
        var _this = this;
        var mgr = cc.director.getPhysics3DManager();
        mgr.enabled = true;
        mgr.useFixedTime = true;
        mgr.deltaTime = 1 / 60;
        this.pushs.forEach(function (push) {
            cc.tween(push)
                .to(2, { z: 0 })
                .to(2, { z: -3 })
                .union()
                .repeatForever()
                .start();
        });
        this.schedule(function () {
            _this._coins.forEach(function (coin) {
                if (coin.y <= -15) {
                    _this._poolCoin.put(coin);
                    _this._coins.delete(coin);
                }
            });
            cc.log(_this._poolCoin.size(), _this._coins.size);
        }, 1);
    };
    Test3d.prototype.onDestroy = function () {
        // super.onDestroy()
        var mgr = cc.director.getPhysics3DManager();
        mgr.enabled = false;
    };
    Test3d.prototype.onBack = function () {
        // Global.layerMgr.hallScene()
    };
    __decorate([
        property(cc.Node)
    ], Test3d.prototype, "coin", void 0);
    __decorate([
        property([cc.Node])
    ], Test3d.prototype, "pushs", void 0);
    Test3d = __decorate([
        ccclass
    ], Test3d);
    return Test3d;
}(cc.Component));
exports.default = Test3d;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Base/FitScene.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '6cfafhc0ZZI5JpEzaKYa31i', 'FitScene');
// Script/Base/FitScene.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var FitScene = /** @class */ (function (_super) {
    __extends(FitScene, _super);
    function FitScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.widgetsTop = [];
        return _this;
    }
    FitScene.prototype.onLoad = function () {
        var canvas = this.getComponent(cc.Canvas);
        canvas.fitWidth = true;
        canvas.fitHeight = false;
        if (cc.winSize.height / cc.winSize.width < canvas.designResolution.height / canvas.designResolution.width) {
            canvas.fitWidth = false;
            canvas.fitHeight = true;
        }
        if (cc.sys.os === cc.sys.OS_IOS) {
            var safeArea_1 = cc.sys.getSafeAreaRect();
            this.widgetsTop.forEach(function (w) {
                w.top += cc.winSize.height - safeArea_1.height;
            });
        }
    };
    __decorate([
        property([cc.Widget])
    ], FitScene.prototype, "widgetsTop", void 0);
    FitScene = __decorate([
        ccclass
    ], FitScene);
    return FitScene;
}(cc.Component));
exports.default = FitScene;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------
