
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/i18n-plugin/LanguageData.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '61de062n4dJ7ZM9/Xdumozn', 'LanguageData');
// LanguageData.js

"use strict";

var Polyglot = require('polyglot.min');

var polyInst = null;

if (!window.i18n) {
  window.i18n = {
    languages: {},
    curLang: ''
  };
}

if (CC_EDITOR) {
  Editor.Profile.load('profile://project/i18n.json', function (err, profile) {
    window.i18n.curLang = profile.data['default_language'];

    if (polyInst) {
      var data = loadLanguageData(window.i18n.curLang) || {};
      initPolyglot(data);
    }
  });
}

function loadLanguageData(language) {
  return window.i18n.languages[language];
}

function initPolyglot(data) {
  if (data) {
    if (polyInst) {
      polyInst.replace(data);
    } else {
      polyInst = new Polyglot({
        phrases: data,
        allowMissing: true
      });
    }
  }
}

module.exports = {
  /**
   * This method allow you to switch language during runtime, language argument should be the same as your data file name
   * such as when language is 'zh', it will load your 'zh.js' data source.
   * @method init
   * @param language - the language specific data file name, such as 'zh' to load 'zh.js'
   */
  init: function init(language) {
    if (language === window.i18n.curLang) {
      return;
    }

    var data = loadLanguageData(language) || {};
    window.i18n.curLang = language;
    initPolyglot(data);
    this.inst = polyInst;
  },

  /**
   * this method takes a text key as input, and return the localized string
   * Please read https://github.com/airbnb/polyglot.js for details
   * @method t
   * @return {String} localized string
   * @example
   *
   * var myText = i18n.t('MY_TEXT_KEY');
   *
   * // if your data source is defined as
   * // {"hello_name": "Hello, %{name}"}
   * // you can use the following to interpolate the text
   * var greetingText = i18n.t('hello_name', {name: 'nantas'}); // Hello, nantas
   */
  t: function t(key, opt) {
    if (polyInst) {
      return polyInst.t(key, opt);
    }
  },
  inst: polyInst,
  updateSceneRenderers: function updateSceneRenderers() {
    // very costly iterations
    var rootNodes = cc.director.getScene().children; // walk all nodes with localize label and update

    var allLocalizedLabels = [];

    for (var i = 0; i < rootNodes.length; ++i) {
      var labels = rootNodes[i].getComponentsInChildren('LocalizedLabel');
      Array.prototype.push.apply(allLocalizedLabels, labels);
    }

    for (var _i = 0; _i < allLocalizedLabels.length; ++_i) {
      var label = allLocalizedLabels[_i];
      if (!label.node.active) continue;
      label.updateLabel();
    } // walk all nodes with localize sprite and update


    var allLocalizedSprites = [];

    for (var _i2 = 0; _i2 < rootNodes.length; ++_i2) {
      var sprites = rootNodes[_i2].getComponentsInChildren('LocalizedSprite');

      Array.prototype.push.apply(allLocalizedSprites, sprites);
    }

    for (var _i3 = 0; _i3 < allLocalizedSprites.length; ++_i3) {
      var sprite = allLocalizedSprites[_i3];
      if (!sprite.node.active) continue;
      sprite.updateSprite(window.i18n.curLang);
    }
  }
};

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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