
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/i18n-plugin/LocalizedLabel.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '744dcs4DCdNprNhG0xwq6FK', 'LocalizedLabel');
// LocalizedLabel.js

"use strict";

var i18n = require('LanguageData'); // Returns a function, that, as long as it continues to be invoked, will not
// be triggered. The function will be called after it stops being called for
// N milliseconds. If `immediate` is passed, trigger the function on the
// leading edge, instead of the trailing.


function debounce(func, wait, immediate) {
  var timeout;
  return function () {
    var context = this,
        args = arguments;

    var later = function later() {
      timeout = null;
      if (!immediate) func.apply(context, args);
    };

    var callNow = immediate && !timeout;
    clearTimeout(timeout);
    timeout = setTimeout(later, wait);
    if (callNow) func.apply(context, args);
  };
}

cc.Class({
  "extends": cc.Component,
  editor: {
    executeInEditMode: true,
    menu: 'i18n/LocalizedLabel'
  },
  properties: {
    dataID: {
      get: function get() {
        return this._dataID;
      },
      set: function set(val) {
        if (this._dataID !== val) {
          this._dataID = val;

          if (CC_EDITOR) {
            this._debouncedUpdateLabel();
          } else {
            this.updateLabel();
          }
        }
      }
    },
    _dataID: ''
  },
  onLoad: function onLoad() {
    if (CC_EDITOR) {
      this._debouncedUpdateLabel = debounce(this.updateLabel, 200);
    }

    if (!i18n.inst) {
      i18n.init();
    } // cc.log('dataID: ' + this.dataID + ' value: ' + i18n.t(this.dataID));


    this.fetchRender();
  },
  fetchRender: function fetchRender() {
    var label = this.getComponent(cc.Label);

    if (label) {
      this.label = label;
      this.updateLabel();
      return;
    }
  },
  updateLabel: function updateLabel() {
    if (!this.label) {
      cc.error('Failed to update localized label, label component is invalid!');
      return;
    }

    var localizedString = i18n.t(this.dataID);

    if (localizedString) {
      this.label.string = i18n.t(this.dataID);
    }
  }
});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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