
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/i18n-plugin/LocalizedSprite.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'f34ac2GGiVOBbG6XlfvgYP4', 'LocalizedSprite');
// LocalizedSprite.js

"use strict";

var SpriteFrameSet = require('SpriteFrameSet');

cc.Class({
  "extends": cc.Component,
  editor: {
    executeInEditMode: true,
    inspector: 'packages://i18n/inspector/localized-sprite.js',
    menu: 'i18n/LocalizedSprite'
  },
  properties: {
    spriteFrameSet: {
      "default": [],
      type: SpriteFrameSet
    }
  },
  onLoad: function onLoad() {
    this.fetchRender();
  },
  fetchRender: function fetchRender() {
    var sprite = this.getComponent(cc.Sprite);

    if (sprite) {
      this.sprite = sprite;
      this.updateSprite(window.i18n.curLang);
      return;
    }
  },
  getSpriteFrameByLang: function getSpriteFrameByLang(lang) {
    for (var i = 0; i < this.spriteFrameSet.length; ++i) {
      if (this.spriteFrameSet[i].language === lang) {
        return this.spriteFrameSet[i].spriteFrame;
      }
    }
  },
  updateSprite: function updateSprite(language) {
    if (!this.sprite) {
      cc.error('Failed to update localized sprite, sprite component is invalid!');
      return;
    }

    var spriteFrame = this.getSpriteFrameByLang(language);

    if (!spriteFrame && this.spriteFrameSet[0]) {
      spriteFrame = this.spriteFrameSet[0].spriteFrame;
    }

    this.sprite.spriteFrame = spriteFrame;
  }
});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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