"use strict";
cc._RF.push(module, '33b50ijJQVMXZifJfylB4SR', 'Test3d');
// Script/Test3d.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
// import Global from "./Global";
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Test3d = /** @class */ (function (_super) {
    __extends(Test3d, _super);
    function Test3d() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.coin = null;
        _this.pushs = [];
        _this._poolCoin = new cc.NodePool();
        _this._coins = new Set();
        return _this;
    }
    Test3d.prototype.genCoin = function () {
        for (var i = 0; i < 1; i++) {
            this.createCoin();
        }
    };
    Test3d.prototype.createCoin = function () {
        var node;
        if (this._poolCoin.size() > 0) {
            node = this._poolCoin.get();
        }
        else {
            node = cc.instantiate(this.coin);
        }
        this._coins.add(node);
        node.x = Math.random() * 6 - 3;
        node.y = Math.random() * 2 + 2;
        node.z = Math.random() * 6 - 3;
        node.active = true;
        node.parent = this.coin.parent;
    };
    Test3d.prototype.onLoad = function () {
        // super.onLoad()
        var _this = this;
        var mgr = cc.director.getPhysics3DManager();
        mgr.enabled = true;
        mgr.useFixedTime = true;
        mgr.deltaTime = 1 / 60;
        this.pushs.forEach(function (push) {
            cc.tween(push)
                .to(2, { z: 0 })
                .to(2, { z: -3 })
                .union()
                .repeatForever()
                .start();
        });
        this.schedule(function () {
            _this._coins.forEach(function (coin) {
                if (coin.y <= -15) {
                    _this._poolCoin.put(coin);
                    _this._coins.delete(coin);
                }
            });
            cc.log(_this._poolCoin.size(), _this._coins.size);
        }, 1);
    };
    Test3d.prototype.onDestroy = function () {
        // super.onDestroy()
        var mgr = cc.director.getPhysics3DManager();
        mgr.enabled = false;
    };
    Test3d.prototype.onBack = function () {
        // Global.layerMgr.hallScene()
    };
    __decorate([
        property(cc.Node)
    ], Test3d.prototype, "coin", void 0);
    __decorate([
        property([cc.Node])
    ], Test3d.prototype, "pushs", void 0);
    Test3d = __decorate([
        ccclass
    ], Test3d);
    return Test3d;
}(cc.Component));
exports.default = Test3d;

cc._RF.pop();