
const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {


    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    player:any;
    playerTile: any;
    tiledMap: cc.TiledMap;
    barriers: any;
    stars: any;
    startTile: any;
    endTile: any;
    label: any;
    endPos: cc.Vec2;
    startPos: cc.Vec2;
    distance: number;
    catlable: any;
    start () {

    }
    onLoad() {
        this.catlable=this.node.getChildByName("catlable");
        this.label=this.node.getChildByName("Poslable");
        this.player = this.node.getChildByName('player');
        this.loadMap();

        this.node.on(cc.Node.EventType.TOUCH_MOVE,this.Box,this);
        //this.node.on(cc.Node.EventType.TOUCH_START,this.Box,this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
    }

    Box(event) {
  
         let Pos:any;
         let Node= event.target;//获取点击到的组件
         Pos=event.getLocation();//触摸的世界坐标
         Pos=this.node.convertToNodeSpaceAR(event.getLocation());//触摸坐标转换为局部坐标
         this.label.string+=Pos.toString();

         //向量计算距离
         this.startPos = cc.v2(this.player.x, this.player.y);
         this.endPos = cc.v2(Pos.x, Pos.y);
         this.distance = this.startPos.sub(this.endPos).mag();
         
        // this.label.string=Pos.toString();
             switch (this.distance) {
             case 0:
                 break;
             case 50://可直接移动的位置
                     this.CatMove(Pos);
                 break;
             default://显示可移动范围
             this.CatMove(Pos);
                 break;
             }
     }
     CatMove(Pos){
        //移动动作
        let action = cc.moveTo(0.1,cc.v2(Pos.x,Pos.y));
        
        //moveto无法移动到准确位置，回调手动修改位置
       /* var finished=cc.callFunc(function()
        {
            this.player.position=Pos;
            
        },this);
        //播放动作以及回调函数
        var sss=cc.sequence(action,finished);*/
        this.player.runAction(action);

        //lable测试
        //this.label.string=Pos.position.toString();
        this.catlable.string=this.player.position.toString();
        
        //50以内是否已经走过的格子
       
    }
    onKeyDown(event){
        var newTile = cc.p(this.playerTile.x, this.playerTile.y);
        switch(event.keyCode) {
            case cc.macro.KEY.up:
                newTile.y -= 1;
                break;
            case cc.macro.KEY.down:
                newTile.y += 1;
                break;
            case cc.macro.KEY.left:
                newTile.x -= 1;
                break;
            case cc.macro.KEY.right:
                newTile.x += 1;
                break;
            default:
                return;
        }
        this.tryMoveToNewTile(newTile);
    }

    //加载地图文件时调用
    loadMap () {
        //初始化地图位置
        this.node.setPosition(0,0);
        //地图
        this.tiledMap = this.node.getComponent(cc.TiledMap);
        //players对象层
        let players = this.tiledMap.getObjectGroup('players');
        //startPoint和endPoint对象
        let startPoint = players.getObject('startPoint');
        let endPoint = players.getObject('endPoint');
        //像素坐标
        let startPos = cc.p(startPoint.offset.x, startPoint.offset.y);
        let endPos = cc.p(endPoint.offset.x, endPoint.offset.y);
        //障碍物图层和星星图层
        this.barriers = this.tiledMap.getLayer('barriers');
        this.stars = this.tiledMap.getLayer('stars');
        //出生Tile和结束Tile
        this.playerTile = this.startTile = this.getTilePos(startPos);
        this.endTile = this.getTilePos(endPos);
        //更新player位置
        this.updatePlayerPos();
    }
    tryMoveToNewTile(newTile) {
        let width = this.tiledMap.node.width;
        let height = this.tiledMap.node.height;
        if (newTile.x < 0 || newTile.x >= width) return;
        if (newTile.y < 0 || newTile.y >= height) return;

        if (this.barriers.getTileGIDAt(newTile)) {//GID=0,则该Tile为空
            cc.log('This way is blocked!');
            return false;
        }

        this.tryCatchStar(newTile);

        this.playerTile = newTile;
        this.updatePlayerPos();

        /*if (cc.pointEqualToPoint(this.playerTile, this.endTile)) {
            cc.log('succeed');
        }*/
    }

    tryCatchStar(newTile){
        let GID = this.stars.getTileGIDAt(newTile);
        let prop = this.tiledMap.getPropertiesForGID(GID);

        if (this.stars.getTileGIDAt(newTile)) {//GID=0,则该Tile为空
            this.stars.removeTileAt(newTile);
        }


    }

    //将像素坐标转化为瓦片坐标
    getTilePos(posInPixel) {
        let mapSize = this.node.getContentSize();
        let tileSize = this.tiledMap.getTileSize();
        let x = Math.floor(posInPixel.x / tileSize.width);
        let y = Math.floor(posInPixel.y / tileSize.height);
        return cc.p(x, y);
    }

    updatePlayerPos() {
        let pos = this.barriers.getPositionAt(this.playerTile);
        this.player.setPosition(pos);
    }
    update (dt) {

    }
}
