"use strict";
cc._RF.push(module, '71675r6L9RJN4r/6bUlY57h', 'map');
// Scripts/map.js

'use strict';

cc.Class({
    extends: cc.Component,

    properties: {},

    // use this for initialization
    onLoad: function onLoad() {
        this.player = this.node.getChildByName('player');
        this.loadMap();

        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.Box, this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
    },

    Box: function Box(event) {},

    onKeyDown: function onKeyDown(event) {
        var newTile = cc.p(this.playerTile.x, this.playerTile.y);
        switch (event.keyCode) {
            case cc.KEY.up:
                newTile.y -= 1;
                break;
            case cc.KEY.down:
                newTile.y += 1;
                break;
            case cc.KEY.left:
                newTile.x -= 1;
                break;
            case cc.KEY.right:
                newTile.x += 1;
                break;
            default:
                return;
        }
        this.tryMoveToNewTile(newTile);
    },

    //加载地图文件时调用
    loadMap: function loadMap() {
        //初始化地图位置
        this.node.setPosition(cc.visibleRect.bottomLeft);
        //地图
        this.tiledMap = this.node.getComponent(cc.TiledMap);
        //players对象层
        var players = this.tiledMap.getObjectGroup('players');
        //startPoint和endPoint对象
        var startPoint = players.getObject('startPoint');
        var endPoint = players.getObject('endPoint');
        //像素坐标
        var startPos = cc.p(startPoint.offset.x, startPoint.offset.y);
        var endPos = cc.p(endPoint.offset.x, endPoint.offset.y);
        //障碍物图层和星星图层
        this.barriers = this.tiledMap.getLayer('barriers');
        this.stars = this.tiledMap.getLayer('stars');
        //出生Tile和结束Tile
        this.playerTile = this.startTile = this.getTilePos(startPos);
        this.endTile = this.getTilePos(endPos);
        //更新player位置
        this.updatePlayerPos();
    },

    tryMoveToNewTile: function tryMoveToNewTile(newTile) {
        var width = this.tiledMap.node.width;
        var height = this.tiledMap.node.height;
        if (newTile.x < 0 || newTile.x >= width) return;
        if (newTile.y < 0 || newTile.y >= height) return;

        if (this.barriers.getTileGIDAt(newTile)) {
            //GID=0,则该Tile为空
            cc.log('This way is blocked!');
            return false;
        }

        this.tryCatchStar(newTile);

        this.playerTile = newTile;
        this.updatePlayerPos();

        if (cc.pointEqualToPoint(this.playerTile, this.endTile)) {
            cc.log('succeed');
        }
    },

    tryCatchStar: function tryCatchStar(newTile) {
        var GID = this.stars.getTileGIDAt(newTile);
        var prop = this.tiledMap.getPropertiesForGID(GID);

        if (this.stars.getTileGIDAt(newTile)) {
            //GID=0,则该Tile为空
            this.stars.removeTileAt(newTile);
        }
    },

    //将像素坐标转化为瓦片坐标
    getTilePos: function getTilePos(posInPixel) {
        var mapSize = this.node.getContentSize();
        var tileSize = this.tiledMap.getTileSize();
        var x = Math.floor(posInPixel.x / tileSize.width);
        var y = Math.floor(posInPixel.y / tileSize.height);
        return cc.p(x, y);
    },

    updatePlayerPos: function updatePlayerPos() {
        var pos = this.barriers.getPositionAt(this.playerTile);
        this.player.setPosition(pos);
    }

});

cc._RF.pop();