"use strict";
cc._RF.push(module, 'c8e8bNWJJ1KJp0ZRA3Kv5m/', 'cont');
// cont.ts

Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var NewClass = /** @class */ (function (_super) {
    __extends(NewClass, _super);
    function NewClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    NewClass.prototype.start = function () {
    };
    NewClass.prototype.onLoad = function () {
        this.catlable = this.node.getChildByName("catlable");
        this.label = this.node.getChildByName("Poslable");
        this.player = this.node.getChildByName('player');
        this.loadMap();
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.Box, this);
        //this.node.on(cc.Node.EventType.TOUCH_START,this.Box,this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
    };
    NewClass.prototype.Box = function (event) {
        var Pos;
        var Node = event.target; //获取点击到的组件
        Pos = event.getLocation(); //触摸的世界坐标
        Pos = this.node.convertToNodeSpaceAR(event.getLocation()); //触摸坐标转换为局部坐标
        this.label.string += Pos.toString();
        //向量计算距离
        this.startPos = cc.v2(this.player.x, this.player.y);
        this.endPos = cc.v2(Pos.x, Pos.y);
        this.distance = this.startPos.sub(this.endPos).mag();
        // this.label.string=Pos.toString();
        switch (this.distance) {
            case 0:
                break;
            case 50: //可直接移动的位置
                this.CatMove(Pos);
                break;
            default: //显示可移动范围
                this.CatMove(Pos);
                break;
        }
    };
    NewClass.prototype.CatMove = function (Pos) {
        //移动动作
        var action = cc.moveTo(0.1, cc.v2(Pos.x, Pos.y));
        //moveto无法移动到准确位置，回调手动修改位置
        /* var finished=cc.callFunc(function()
         {
             this.player.position=Pos;
             
         },this);
         //播放动作以及回调函数
         var sss=cc.sequence(action,finished);*/
        this.player.runAction(action);
        //lable测试
        //this.label.string=Pos.position.toString();
        this.catlable.string = this.player.position.toString();
        //50以内是否已经走过的格子
    };
    NewClass.prototype.onKeyDown = function (event) {
        var newTile = cc.p(this.playerTile.x, this.playerTile.y);
        switch (event.keyCode) {
            case cc.macro.KEY.up:
                newTile.y -= 1;
                break;
            case cc.macro.KEY.down:
                newTile.y += 1;
                break;
            case cc.macro.KEY.left:
                newTile.x -= 1;
                break;
            case cc.macro.KEY.right:
                newTile.x += 1;
                break;
            default:
                return;
        }
        this.tryMoveToNewTile(newTile);
    };
    //加载地图文件时调用
    NewClass.prototype.loadMap = function () {
        //初始化地图位置
        this.node.setPosition(0, 0);
        //地图
        this.tiledMap = this.node.getComponent(cc.TiledMap);
        //players对象层
        var players = this.tiledMap.getObjectGroup('players');
        //startPoint和endPoint对象
        var startPoint = players.getObject('startPoint');
        var endPoint = players.getObject('endPoint');
        //像素坐标
        var startPos = cc.p(startPoint.offset.x, startPoint.offset.y);
        var endPos = cc.p(endPoint.offset.x, endPoint.offset.y);
        //障碍物图层和星星图层
        this.barriers = this.tiledMap.getLayer('barriers');
        this.stars = this.tiledMap.getLayer('stars');
        //出生Tile和结束Tile
        this.playerTile = this.startTile = this.getTilePos(startPos);
        this.endTile = this.getTilePos(endPos);
        //更新player位置
        this.updatePlayerPos();
    };
    NewClass.prototype.tryMoveToNewTile = function (newTile) {
        var width = this.tiledMap.node.width;
        var height = this.tiledMap.node.height;
        if (newTile.x < 0 || newTile.x >= width)
            return;
        if (newTile.y < 0 || newTile.y >= height)
            return;
        if (this.barriers.getTileGIDAt(newTile)) { //GID=0,则该Tile为空
            cc.log('This way is blocked!');
            return false;
        }
        this.tryCatchStar(newTile);
        this.playerTile = newTile;
        this.updatePlayerPos();
        /*if (cc.pointEqualToPoint(this.playerTile, this.endTile)) {
            cc.log('succeed');
        }*/
    };
    NewClass.prototype.tryCatchStar = function (newTile) {
        var GID = this.stars.getTileGIDAt(newTile);
        var prop = this.tiledMap.getPropertiesForGID(GID);
        if (this.stars.getTileGIDAt(newTile)) { //GID=0,则该Tile为空
            this.stars.removeTileAt(newTile);
        }
    };
    //将像素坐标转化为瓦片坐标
    NewClass.prototype.getTilePos = function (posInPixel) {
        var mapSize = this.node.getContentSize();
        var tileSize = this.tiledMap.getTileSize();
        var x = Math.floor(posInPixel.x / tileSize.width);
        var y = Math.floor(posInPixel.y / tileSize.height);
        return cc.p(x, y);
    };
    NewClass.prototype.updatePlayerPos = function () {
        var pos = this.barriers.getPositionAt(this.playerTile);
        this.player.setPosition(pos);
    };
    NewClass.prototype.update = function (dt) {
    };
    NewClass = __decorate([
        ccclass
    ], NewClass);
    return NewClass;
}(cc.Component));
exports.default = NewClass;

cc._RF.pop();