cc.Class({
    extends: cc.Component,

    properties: {},
    onLoad: function () {
        this.str = []; //测试用
        this.history = [];
        this.toastArray = []; //后进前出
        this.t = {
            a: 0,
            b: 0,
            c: 0
        }; //time,用于abc三个toast的透明度计数
        this.cA = 1; //changeAlpha，渐变工作的计时与update判断
        this.nameArray = ['a', 'b', 'c']; //节点名字的数组集合
        this.nextName = 0; //下一个节点名字的数组序号，循环
        this.isMove = false; //用于新增toast时已存在节点的下移判断
        this.moveTime = 0; //用于平滑下移时记录帧的间隔
    },

    addstr: function (str) {
        //以下实现Toast查重后添加进队列
        for (let i = 0; i < this.str.length; i++) {
            if (this.str[i] == str) return;
        }
        this.str.push(str);
        this.history.unshift(str);
        if (this.cA === 0) this.cA = 1;
    },

    toast: function (num) {
        this.cA += num;
        //以下检测有排队的消息元素和空闲toast则分配消息给空闲toast
        if (this.toastArray.length < 3 && this.str.length > 0 && !this.isMove) {
            let node = this.node.getChildByName(this.nameArray[this.nextName]),
                label = node.getChildByName('Label');
            node.opacity = 0;
            node.active = true;
            this.toastArray.push(node.name);
            this.t[node.name] = this.cA + 3;
            this.nextName += this.nextName > 1 ? -2 : 1;
            label.getComponent(cc.Label).string = this.str.shift();
            node.width = label.width + 20;
            node.height = label.height + 20;
            if (this.toastArray.length > 1) {
                this.isMove = true;
                this.moveTime = 0;
            }
        }
        //以下如果需要移动则平滑移动toastArray中最后一位之前的节点
        if (this.isMove) {
            this.moveTime += num;
            if (0.2 < this.moveTime) {
                this.isMove = false;
                this.moveTime -= 0.2;
            }
            let l = this.toastArray.length - 1,
                h = this.node.getChildByName(this.toastArray[l]).height;
            for (let i = 0; i < l; i++) {
                this.node.getChildByName(this.toastArray[i]).y -= (h + 20) * num / 0.2;
            }
        }
        //以下为透明度渐变即显示到消失的实现（包括关闭active）
        for (let i = 0, l = this.toastArray.length; i < l; i++) {
            let node = this.node.getChildByName(this.toastArray[i]),
                name = this.toastArray[i];
            if (this.cA > this.t[name]) {
                cc.log(4);
                this.t[name] = 0;
                this.toastArray.shift();
                node.y = 0;
                node.active = false;
                if (l === 1) {
                    this.cA = 0;
                    return;
                }
            } else if (this.cA > this.t[name] - 0.2) {
                cc.log(3);
                node.opacity = (this.t[name] - this.cA) * 510;
            } else if (this.cA > this.t[name] - 2.7) {
                cc.log(2);
                node.opacity = 255;
            } else {
                cc.log(1);
                node.opacity += num * 850;
            }
        }
    },

    update: function (dt) {
        if (this.cA) this.toast(dt);
    },
});
//40\1173-7.21