#include "jsb_cocos2dx_live2d.hpp"
#include "scripting/js-bindings/manual/jsb_conversions.hpp"
#include "scripting/js-bindings/manual/jsb_global.h"
#include "LAppView.hpp"

se::Object* __jsb_LAppView_proto = nullptr;
se::Class* __jsb_LAppView_class = nullptr;

static bool js_cocos2dx_live2d_LAppView_GetParameterMaximumValue(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_GetParameterMaximumValue : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 1) {
        unsigned int arg0 = 0;
        ok &= seval_to_uint32(args[0], (uint32_t*)&arg0);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetParameterMaximumValue : Error processing arguments");
        float result = cobj->GetParameterMaximumValue(arg0);
        ok &= float_to_seval(result, &s.rval());
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetParameterMaximumValue : Error processing arguments");
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_GetParameterMaximumValue)

static bool js_cocos2dx_live2d_LAppView_touchEnded(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_touchEnded : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 1) {
        cocos2d::Vec2 arg0;
        ok &= seval_to_Vec2(args[0], &arg0);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_touchEnded : Error processing arguments");
        cobj->touchEnded(arg0);
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_touchEnded)

static bool js_cocos2dx_live2d_LAppView_setScale(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_setScale : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 2) {
        float arg0 = 0;
        float arg1 = 0;
        ok &= seval_to_float(args[0], &arg0);
        ok &= seval_to_float(args[1], &arg1);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_setScale : Error processing arguments");
        cobj->setScale(arg0, arg1);
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_setScale)

static bool js_cocos2dx_live2d_LAppView_GetPartOpacity(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_GetPartOpacity : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 1) {
        int arg0 = 0;
        ok &= seval_to_int32(args[0], (int32_t*)&arg0);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetPartOpacity : Error processing arguments");
        float result = cobj->GetPartOpacity(arg0);
        ok &= float_to_seval(result, &s.rval());
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetPartOpacity : Error processing arguments");
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_GetPartOpacity)

static bool js_cocos2dx_live2d_LAppView_StartRandomMotion(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_StartRandomMotion : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 2) {
        const char* arg0 = nullptr;
        int arg1 = 0;
        std::string arg0_tmp; ok &= seval_to_std_string(args[0], &arg0_tmp); arg0 = arg0_tmp.c_str();
        ok &= seval_to_int32(args[1], (int32_t*)&arg1);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_StartRandomMotion : Error processing arguments");
        cobj->StartRandomMotion(arg0, arg1);
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_StartRandomMotion)

static bool js_cocos2dx_live2d_LAppView_GetPartCount(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_GetPartCount : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 0) {
        int result = cobj->GetPartCount();
        ok &= int32_to_seval(result, &s.rval());
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetPartCount : Error processing arguments");
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_GetPartCount)

static bool js_cocos2dx_live2d_LAppView_MultiplyParameterValue(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_MultiplyParameterValue : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 2) {
        int arg0 = 0;
        float arg1 = 0;
        ok &= seval_to_int32(args[0], (int32_t*)&arg0);
        ok &= seval_to_float(args[1], &arg1);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_MultiplyParameterValue : Error processing arguments");
        cobj->MultiplyParameterValue(arg0, arg1);
        return true;
    }
    if (argc == 3) {
        int arg0 = 0;
        float arg1 = 0;
        float arg2 = 0;
        ok &= seval_to_int32(args[0], (int32_t*)&arg0);
        ok &= seval_to_float(args[1], &arg1);
        ok &= seval_to_float(args[2], &arg2);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_MultiplyParameterValue : Error processing arguments");
        cobj->MultiplyParameterValue(arg0, arg1, arg2);
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_MultiplyParameterValue)

static bool js_cocos2dx_live2d_LAppView_touchMoved(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_touchMoved : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 1) {
        cocos2d::Vec2 arg0;
        ok &= seval_to_Vec2(args[0], &arg0);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_touchMoved : Error processing arguments");
        cobj->touchMoved(arg0);
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_touchMoved)

static bool js_cocos2dx_live2d_LAppView_touchBegan(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_touchBegan : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 1) {
        cocos2d::Vec2 arg0;
        ok &= seval_to_Vec2(args[0], &arg0);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_touchBegan : Error processing arguments");
        cobj->touchBegan(arg0);
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_touchBegan)

static bool js_cocos2dx_live2d_LAppView_SetParameterValue(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_SetParameterValue : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 2) {
        int arg0 = 0;
        float arg1 = 0;
        ok &= seval_to_int32(args[0], (int32_t*)&arg0);
        ok &= seval_to_float(args[1], &arg1);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_SetParameterValue : Error processing arguments");
        cobj->SetParameterValue(arg0, arg1);
        return true;
    }
    if (argc == 3) {
        int arg0 = 0;
        float arg1 = 0;
        float arg2 = 0;
        ok &= seval_to_int32(args[0], (int32_t*)&arg0);
        ok &= seval_to_float(args[1], &arg1);
        ok &= seval_to_float(args[2], &arg2);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_SetParameterValue : Error processing arguments");
        cobj->SetParameterValue(arg0, arg1, arg2);
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_SetParameterValue)

static bool js_cocos2dx_live2d_LAppView_SetRandomExpression(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_SetRandomExpression : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    if (argc == 0) {
        cobj->SetRandomExpression();
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_SetRandomExpression)

static bool js_cocos2dx_live2d_LAppView_GetParameterCount(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_GetParameterCount : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 0) {
        int result = cobj->GetParameterCount();
        ok &= int32_to_seval(result, &s.rval());
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetParameterCount : Error processing arguments");
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_GetParameterCount)

static bool js_cocos2dx_live2d_LAppView_AddParameterValue(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_AddParameterValue : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 2) {
        int arg0 = 0;
        float arg1 = 0;
        ok &= seval_to_int32(args[0], (int32_t*)&arg0);
        ok &= seval_to_float(args[1], &arg1);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_AddParameterValue : Error processing arguments");
        cobj->AddParameterValue(arg0, arg1);
        return true;
    }
    if (argc == 3) {
        int arg0 = 0;
        float arg1 = 0;
        float arg2 = 0;
        ok &= seval_to_int32(args[0], (int32_t*)&arg0);
        ok &= seval_to_float(args[1], &arg1);
        ok &= seval_to_float(args[2], &arg2);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_AddParameterValue : Error processing arguments");
        cobj->AddParameterValue(arg0, arg1, arg2);
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_AddParameterValue)

static bool js_cocos2dx_live2d_LAppView_GetParameterMinimumValue(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_GetParameterMinimumValue : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 1) {
        unsigned int arg0 = 0;
        ok &= seval_to_uint32(args[0], (uint32_t*)&arg0);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetParameterMinimumValue : Error processing arguments");
        float result = cobj->GetParameterMinimumValue(arg0);
        ok &= float_to_seval(result, &s.rval());
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetParameterMinimumValue : Error processing arguments");
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_GetParameterMinimumValue)

static bool js_cocos2dx_live2d_LAppView_setModel(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_setModel : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 2) {
        std::string arg0;
        std::string arg1;
        ok &= seval_to_std_string(args[0], &arg0);
        ok &= seval_to_std_string(args[1], &arg1);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_setModel : Error processing arguments");
        bool result = cobj->setModel(arg0, arg1);
        ok &= boolean_to_seval(result, &s.rval());
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_setModel : Error processing arguments");
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_setModel)

static bool js_cocos2dx_live2d_LAppView_StartMotion(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_StartMotion : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 3) {
        const char* arg0 = nullptr;
        int arg1 = 0;
        int arg2 = 0;
        std::string arg0_tmp; ok &= seval_to_std_string(args[0], &arg0_tmp); arg0 = arg0_tmp.c_str();
        ok &= seval_to_int32(args[1], (int32_t*)&arg1);
        ok &= seval_to_int32(args[2], (int32_t*)&arg2);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_StartMotion : Error processing arguments");
        cobj->StartMotion(arg0, arg1, arg2);
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_StartMotion)

static bool js_cocos2dx_live2d_LAppView_setPosition(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_setPosition : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 2) {
        float arg0 = 0;
        float arg1 = 0;
        ok &= seval_to_float(args[0], &arg0);
        ok &= seval_to_float(args[1], &arg1);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_setPosition : Error processing arguments");
        cobj->setPosition(arg0, arg1);
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_setPosition)

static bool js_cocos2dx_live2d_LAppView_GetCanvasHeight(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_GetCanvasHeight : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 0) {
        float result = cobj->GetCanvasHeight();
        ok &= float_to_seval(result, &s.rval());
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetCanvasHeight : Error processing arguments");
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_GetCanvasHeight)

static bool js_cocos2dx_live2d_LAppView_GetParameterDefaultValue(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_GetParameterDefaultValue : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 1) {
        unsigned int arg0 = 0;
        ok &= seval_to_uint32(args[0], (uint32_t*)&arg0);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetParameterDefaultValue : Error processing arguments");
        float result = cobj->GetParameterDefaultValue(arg0);
        ok &= float_to_seval(result, &s.rval());
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetParameterDefaultValue : Error processing arguments");
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_GetParameterDefaultValue)

static bool js_cocos2dx_live2d_LAppView_GetParameterValue(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_GetParameterValue : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 1) {
        int arg0 = 0;
        ok &= seval_to_int32(args[0], (int32_t*)&arg0);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetParameterValue : Error processing arguments");
        float result = cobj->GetParameterValue(arg0);
        ok &= float_to_seval(result, &s.rval());
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetParameterValue : Error processing arguments");
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_GetParameterValue)

static bool js_cocos2dx_live2d_LAppView_GetCanvasWidth(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_GetCanvasWidth : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 0) {
        float result = cobj->GetCanvasWidth();
        ok &= float_to_seval(result, &s.rval());
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_GetCanvasWidth : Error processing arguments");
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_GetCanvasWidth)

static bool js_cocos2dx_live2d_LAppView_SetExpression(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_SetExpression : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 1) {
        const char* arg0 = nullptr;
        std::string arg0_tmp; ok &= seval_to_std_string(args[0], &arg0_tmp); arg0 = arg0_tmp.c_str();
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_SetExpression : Error processing arguments");
        cobj->SetExpression(arg0);
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_SetExpression)

static bool js_cocos2dx_live2d_LAppView_SetPartOpacity(se::State& s)
{
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    SE_PRECONDITION2(cobj, false, "js_cocos2dx_live2d_LAppView_SetPartOpacity : Invalid Native Object");
    const auto& args = s.args();
    size_t argc = args.size();
    CC_UNUSED bool ok = true;
    if (argc == 2) {
        int arg0 = 0;
        float arg1 = 0;
        ok &= seval_to_int32(args[0], (int32_t*)&arg0);
        ok &= seval_to_float(args[1], &arg1);
        SE_PRECONDITION2(ok, false, "js_cocos2dx_live2d_LAppView_SetPartOpacity : Error processing arguments");
        cobj->SetPartOpacity(arg0, arg1);
        return true;
    }
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
    return false;
}
SE_BIND_FUNC(js_cocos2dx_live2d_LAppView_SetPartOpacity)

SE_DECLARE_FINALIZE_FUNC(js_LAppView_finalize)

static bool js_cocos2dx_live2d_LAppView_constructor(se::State& s)
{
    LAppView* cobj = new (std::nothrow) LAppView();
    s.thisObject()->setPrivateData(cobj);
    return true;
}
SE_BIND_CTOR(js_cocos2dx_live2d_LAppView_constructor, __jsb_LAppView_class, js_LAppView_finalize)



extern se::Object* __jsb_cocos2d_Node_proto;

static bool js_LAppView_finalize(se::State& s)
{
    CCLOGINFO("jsbindings: finalizing JS object %p (LAppView)", s.nativeThisObject());
    LAppView* cobj = (LAppView*)s.nativeThisObject();
    if (cobj->getReferenceCount() == 1)
        cobj->autorelease();
    else
        cobj->release();
    return true;
}
SE_BIND_FINALIZE_FUNC(js_LAppView_finalize)

bool js_register_cocos2dx_live2d_LAppView(se::Object* obj)
{
    auto cls = se::Class::create("LAppView", obj, __jsb_cocos2d_Node_proto, _SE(js_cocos2dx_live2d_LAppView_constructor));

    cls->defineFunction("GetParameterMaximumValue", _SE(js_cocos2dx_live2d_LAppView_GetParameterMaximumValue));
    cls->defineFunction("touchEnded", _SE(js_cocos2dx_live2d_LAppView_touchEnded));
    cls->defineFunction("setScale", _SE(js_cocos2dx_live2d_LAppView_setScale));
    cls->defineFunction("GetPartOpacity", _SE(js_cocos2dx_live2d_LAppView_GetPartOpacity));
    cls->defineFunction("StartRandomMotion", _SE(js_cocos2dx_live2d_LAppView_StartRandomMotion));
    cls->defineFunction("GetPartCount", _SE(js_cocos2dx_live2d_LAppView_GetPartCount));
    cls->defineFunction("MultiplyParameterValue", _SE(js_cocos2dx_live2d_LAppView_MultiplyParameterValue));
    cls->defineFunction("touchMoved", _SE(js_cocos2dx_live2d_LAppView_touchMoved));
    cls->defineFunction("touchBegan", _SE(js_cocos2dx_live2d_LAppView_touchBegan));
    cls->defineFunction("SetParameterValue", _SE(js_cocos2dx_live2d_LAppView_SetParameterValue));
    cls->defineFunction("SetRandomExpression", _SE(js_cocos2dx_live2d_LAppView_SetRandomExpression));
    cls->defineFunction("GetParameterCount", _SE(js_cocos2dx_live2d_LAppView_GetParameterCount));
    cls->defineFunction("AddParameterValue", _SE(js_cocos2dx_live2d_LAppView_AddParameterValue));
    cls->defineFunction("GetParameterMinimumValue", _SE(js_cocos2dx_live2d_LAppView_GetParameterMinimumValue));
    cls->defineFunction("setModel", _SE(js_cocos2dx_live2d_LAppView_setModel));
    cls->defineFunction("StartMotion", _SE(js_cocos2dx_live2d_LAppView_StartMotion));
    cls->defineFunction("setPosition", _SE(js_cocos2dx_live2d_LAppView_setPosition));
    cls->defineFunction("GetCanvasHeight", _SE(js_cocos2dx_live2d_LAppView_GetCanvasHeight));
    cls->defineFunction("GetParameterDefaultValue", _SE(js_cocos2dx_live2d_LAppView_GetParameterDefaultValue));
    cls->defineFunction("GetParameterValue", _SE(js_cocos2dx_live2d_LAppView_GetParameterValue));
    cls->defineFunction("GetCanvasWidth", _SE(js_cocos2dx_live2d_LAppView_GetCanvasWidth));
    cls->defineFunction("SetExpression", _SE(js_cocos2dx_live2d_LAppView_SetExpression));
    cls->defineFunction("SetPartOpacity", _SE(js_cocos2dx_live2d_LAppView_SetPartOpacity));
    cls->defineFinalizeFunction(_SE(js_LAppView_finalize));
    cls->install();
    JSBClassType::registerClass<LAppView>(cls);

    __jsb_LAppView_proto = cls->getProto();
    __jsb_LAppView_class = cls;

    se::ScriptEngine::getInstance()->clearException();
    return true;
}

bool register_all_cocos2dx_live2d(se::Object* obj)
{
    // Get the ns
    se::Value nsVal;
    if (!obj->getProperty("cc", &nsVal))
    {
        se::HandleObject jsobj(se::Object::createPlainObject());
        nsVal.setObject(jsobj);
        obj->setProperty("cc", nsVal);
    }
    se::Object* ns = nsVal.toObject();

    js_register_cocos2dx_live2d_LAppView(ns);
    return true;
}

