

import * as cc from "cc";
const { ccclass } = cc._decorator;

@ccclass("CCHELP")
export class CCHELP {

    public static TimeEnum = {
        日: 0,
        时: 1,
        分: 2,
        秒: 3,
        毫秒: 4,
    }
    /**
     * 获得当前时间
     * @param timeEnum （日，时，分，秒，毫秒）
     */
    public static GetNowTime(timeEnum: number): number {
        let date = new Date();
        let tadyTime: number =
            timeEnum == this.TimeEnum.日 ? Math.floor(date.getTime() / 86400000) :
                timeEnum == this.TimeEnum.时 ? Math.floor(date.getTime() / 3600000) :
                    timeEnum == this.TimeEnum.分 ? Math.floor(date.getTime() / 60000) :
                        timeEnum == this.TimeEnum.秒 ? Math.floor(date.getTime() / 1000) :
                            Math.floor(date.getTime());

        return tadyTime;
    }

    


    // #region 数学
    

    /**求向量的长度 */
    public static GetPosLong_Vect2(pos_x: number, pos_y: number): number {

        return Math.sqrt(Math.pow(pos_x, 2) + Math.pow(pos_y, 2));
    }

    /**
     * 角度  转  弧度
     * @param jiaodu 角度
     */
    public static JiaoDu2HuDu(jiaodu: number): number {
        //45° --> Math.PI/4, 90--> Math.PI/2, 180 --> Math.PI, 360 --> Math.PI*2
        return (jiaodu / 180) * Math.PI;
    }
    /**
     * 弧度  转  角度
     * @param hudu 弧度
     */
    public static HuDu2JiaoDu(hudu: number): number {
        //45° --> Math.PI/4, 90--> Math.PI/2, 180 --> Math.PI, 360 --> Math.PI*2
        return hudu * 180 / Math.PI;
    }
    /**
    *正弦函数 Math.sin(弧度) Math.cos(弧度) Math.tan(弧度)
    *反弦函数 Math.asin(弧度) Math.acos(弧度) Math.atan(弧度)
    *开根号   Math.sqrt();
    *正弦函数 
    */
    public static SanJiaoHanShu() {
        let begin_jiaodu = -45;
        console.log("begin_jiaodu:", begin_jiaodu);

        let hudu: number = CCHELP.JiaoDu2HuDu(begin_jiaodu);

        console.log("\n", {
            "begin_jiaodu:": begin_jiaodu,
            "hudu": hudu,
            "sinZhi": Math.sin(hudu),
        });

    }

    /**
     * 获得向量对应的角度
     * @param pos_x 
     * @param pos_y 
     */
    public static PosToRotation(pos_x: number, pos_y: number): number {
        return this.HuDu2JiaoDu(Math.atan2(pos_x, pos_y));
    }


    

    // #endregion

    


    //#region 射线检测

    // public static FindObject_SheXian(beginPos: cc.Vec2, overPos: cc.Vec2, type: cc.ray): cc.PhysicsRayCastResult[] {
    //     var results: cc.PhysicsRayResult[] = cc.director.phy().rayCast(beginPos, overPos, type);

    //     return results;
    // }

    /**相机发射射线 返回最近的碰撞器*/
    public static CameraFireRay(camera:cc.CameraComponent, beginPos: cc.Vec2):cc.PhysicsRayResult {

        let ray: cc.geometry.ray = new cc.geometry.ray();
        camera.screenPointToRay(beginPos.x, beginPos.y,ray);
        if (cc.PhysicsSystem.instance.raycastClosest(ray)) {

            const result: cc.PhysicsRayResult = cc.PhysicsSystem.instance.raycastClosestResult;
            return result
        }
    }

    /**相机发射射线 返回射线碰撞到的所有碰撞器*/
    public static CameraFireRayGetPleanPos(camera:cc.CameraComponent,beginPos: cc.Vec2): cc.PhysicsRayResult[] {

        let ray: cc.geometry.ray = new cc.geometry.ray();
        camera.screenPointToRay(beginPos.x, beginPos.y, ray);
        if (cc.PhysicsSystem.instance.raycast(ray)) {

            const results: cc.PhysicsRayResult[] = cc.PhysicsSystem.instance.raycastResults;

            return results;
        }
    }

    //#endregion
}