import * as cc from 'cc';
import { CCHELP } from './CCHELP';
const { ccclass, property } = cc._decorator;

@ccclass('PlayerTouchOperation')
export class PlayerTouchOperation extends cc.Component {

    @property(cc.Prefab)
    public miaoZhunPrefab: cc.Prefab = null;

    @property(cc.CameraComponent)
    public camera: cc.CameraComponent = null;
    private _cameraRoot_H: cc.Node = null;
    private _cameraRoot_V: cc.Node = null;

    private _playerStart: number = 0;
    private _playerStartEnum = {
        "暂停操作": 0,
        "主界面编辑界面": 1,
        "开始游戏，游戏进行中界面": 2,
    }
    /**选中的节点 */
    private _xvanZhongNode: cc.Node = null;
    private _miaoZhunNode: cc.Node = null;

    public onLoad() {

        this._cameraRoot_V = this.camera.node.parent;
        this._cameraRoot_H = this._cameraRoot_V.parent;

        this._xvanZhongNode = null;
        this._miaoZhunNode = null;

    }

    public onEnable() {
        this.OnBindPlayerClickEvent();
    }

    public onDisable() {
        this.OffBindPlayerClickEvent();
    }



    //#region 对象拖动

    private OnBindPlayerClickEvent() {

        cc.systemEvent.on(cc.SystemEventType.TOUCH_START, this.PlayClickStart, this);

        cc.systemEvent.on(cc.SystemEventType.TOUCH_MOVE, this.PlayClickMove, this);

        cc.systemEvent.on(cc.SystemEventType.TOUCH_END, this.PlayClickEnd, this);

        cc.systemEvent.on(cc.SystemEventType.TOUCH_CANCEL, this.PlayClickEnd, this);
    }

    private OffBindPlayerClickEvent() {

        cc.systemEvent.off(cc.SystemEventType.TOUCH_START, this.PlayClickStart, this);

        cc.systemEvent.off(cc.SystemEventType.TOUCH_MOVE, this.PlayClickMove, this);

        cc.systemEvent.off(cc.SystemEventType.TOUCH_END, this.PlayClickEnd, this);

        cc.systemEvent.off(cc.SystemEventType.TOUCH_CANCEL, this.PlayClickEnd, this);
    }

    private PlayClickStart(touch?: cc.Touch, event?: cc.EventTouch) {

        this.PlayerIsClickChess(touch);
    }

    private PlayClickMove(touch?: cc.Touch, event?: cc.EventTouch) {

        if (this._xvanZhongNode == null) {

        } else {

            this.MiaoZhunPlayer(touch);
        }

    }

    private PlayClickEnd(touch?: cc.Touch, event?: cc.EventTouch) {

        if (this._xvanZhongNode == null) {


        } else {

            this.MovePlayer(touch);
        }
    }

    //#endregion

    //#region 游戏进程


    //棋子旋转蓄力
    private PlayerIsClickChess(touch: cc.Touch) {
        let physicsRayResult: cc.PhysicsRayResult = CCHELP.CameraFireRay(this.camera, touch.getStartLocation());

        if (physicsRayResult != null && physicsRayResult.collider.node.name == "Cube") {

            this._xvanZhongNode = physicsRayResult.collider.node;

            let miaozhenNode: cc.Node = cc.instantiate(this.miaoZhunPrefab);
            this._xvanZhongNode.addChild(miaozhenNode);
            miaozhenNode.eulerAngles = cc.v3(0, 0, 0);
            miaozhenNode.position = cc.v3(0, 0.1, 0);
            miaozhenNode.scale = cc.v3(0, 0, 0);
            this._miaoZhunNode = miaozhenNode;
        } else {

            console.error("未选中Cube：",physicsRayResult);
            this._xvanZhongNode = null;
            this._miaoZhunNode = null;
        }
    }
    private MiaoZhunPlayer(touch: cc.Touch) {

        let fangxiang: cc.Vec2 = touch.getLocation().subtract(touch.getStartLocation());

        this._miaoZhunNode.scale = cc.v3(1, 1, this.GetFangXiangLong(fangxiang));
        this._xvanZhongNode.eulerAngles = cc.v3(0, this.GetChessAngles(fangxiang), 0);
    }
    private GetFangXiangLong(fangxiang: cc.Vec2): number {

        let posLong: number = CCHELP.GetPosLong_Vect2(fangxiang.x, fangxiang.y);
        if (posLong > 50) {
            posLong = 50;
        } else if (posLong < 0) {
            posLong = 0;
        }

        return posLong / 50;
    }
    private GetChessAngles(fangxiang: cc.Vec2): number {

        let jiaoDu: number = CCHELP.PosToRotation(fangxiang.x, fangxiang.y);
        let cameraAngles: number = this._cameraRoot_H.eulerAngles.y;

        return cameraAngles - jiaoDu + 180;
    }

    //Cube发射
    private MovePlayer(touch: cc.Touch) {

        let fangxiang: cc.Vec2 = touch.getLocation().subtract(touch.getStartLocation());

        this.FireChess(fangxiang);

        if (!!this._miaoZhunNode) {
            this._miaoZhunNode.destroy();
        }

        this._xvanZhongNode = null;
        this._miaoZhunNode = null;
    }
    private FireChess(fangxiang: cc.Vec2) {

        let rigidBody: cc.RigidBodyComponent = this._xvanZhongNode.getComponent(cc.RigidBodyComponent);

        let long = this.GetFangXiangLong(fangxiang);

        let angle: number = this.GetChessAngles(fangxiang);
        let hudu: number = CCHELP.JiaoDu2HuDu(angle);

        let z: number = Math.cos(hudu) * long * 80;
        let x: number = Math.sin(hudu) * long * 80;


        let togglerPos: cc.Vec3 = cc.v3(-x, 0, -z);
        console.error(long,togglerPos);
        rigidBody.applyImpulse(togglerPos);
    }

    //#endregion
}
