// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        lable: cc.Label,
        gamePageView: cc.PageView,
        gamesListTemplate: cc.Prefab,
        _gamesList: {
            default: []
        },
    },
    gameStage:null,
    gameMode:'',
    stageMode:'',
    mainStageNode:null,
    playerOneStageNode:null,
    playerTwoStageNode:null,

    onLoad () {
        cc.loader.loadRes('jsons/gamesList.json', (err, jsonAsset) => {
            if(err){
                this._gamesList=[]
            }else{
                this._gamesList=jsonAsset.json
            }
        })

        this.mainStageNode=this.node.getChildByName('mainStageNode')
        



        NOTIFICATION.on('Game.Play',this._onGamePlay,this)
        NOTIFICATION.on('Game.Destory',this._onGameDestory,this)
        
    },
    onDestroy () {
        NOTIFICATION.off('Game.Play',this._onGamePlay,this)
        NOTIFICATION.off('Game.Destory',this._onGameDestory,this)
    },

    start () {
        
        
    },
    _onGameDestory(playerData){
        this.playerOneStageNode.removeAllChildren(true)
        this.mainStageNode.active=true
    },
    _onGamePlay(game){   
        
        cc.loader.loadRes("prefabs/Games/"+game.tag, (err, prefab) => {
            if(err)
            {
                cc.log("Load game prefab error")
                return
            }
            

            this.mainStageNode.active=false
            this.gameStage = cc.instantiate(prefab)

            this.playerOneStageNode.addChild(this.gameStage)
            this.playerOneStageNode.active=true
            let wg=this.playerOneStageNode.getComponent(cc.Widget)
            // wg.enabled=false
            let winSize=this.node.getContentSize()
            let newWidth=winSize.height
            let newHeight=winSize.height*newWidth/winSize.width
            // this.playerOneStageNode.scale=newWidth/winSize.width
            // this.playerOneStageNode.rotation=90
            // this.playerOneStageNode.x=-winSize.width/2+this.playerOneStageNode.height/2
            
        });
    },

    changeStageMode (mode) {
        this.stageMode=mode

    },

    changeGameMode (mode) {
        this.lable.string = mode
        this.gameMode=mode
        this.fillGamesList()
    },

    singleMode () {
        this.changeGameMode("Single")
    },

    hotsMode () {
        this.changeGameMode("Hots")
    },

    networkMode () {
        this.changeGameMode("Network")
    },

    fillGamesList () {
        this.gamePageView.removeAllPages()
        this._gamesList.forEach((game,idx)=>{
            var item = cc.instantiate(this.gamesListTemplate)
            
            this.gamePageView.addPage(item)

            var script = item.getComponent('gameListItemJs')
            script.init(game)
        })
        
        var pages=this.gamePageView.getPages()
        console.log(pages)
        pages.forEach((page,idx)=>{
            console.log(`idx: ${idx} x:${page.x} width:${page.width}`)
        })
    }

    // update (dt) {},
});
