"use strict";
cc._RF.push(module, 'e4fe4pXglBEg4wj9Lr2ztbD', 'Main');
// script/Main.js

'use strict';

// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        lable: cc.Label,
        gamePageView: cc.PageView,
        gamesListTemplate: cc.Prefab,
        _gamesList: {
            default: []
        }
    },
    gameStage: null,
    gameMode: '',
    stageMode: '',
    mainStageNode: null,
    playerOneStageNode: null,
    playerTwoStageNode: null,

    onLoad: function onLoad() {
        var _this = this;

        cc.loader.loadRes('jsons/gamesList.json', function (err, jsonAsset) {
            if (err) {
                _this._gamesList = [];
            } else {
                _this._gamesList = jsonAsset.json;
            }
        });

        this.mainStageNode = this.node.getChildByName('mainStageNode');

        NOTIFICATION.on('Game.Play', this._onGamePlay, this);
        NOTIFICATION.on('Game.Destory', this._onGameDestory, this);
    },
    onDestroy: function onDestroy() {
        NOTIFICATION.off('Game.Play', this._onGamePlay, this);
        NOTIFICATION.off('Game.Destory', this._onGameDestory, this);
    },
    start: function start() {},
    _onGameDestory: function _onGameDestory(playerData) {
        this.playerOneStageNode.removeAllChildren(true);
        this.mainStageNode.active = true;
    },
    _onGamePlay: function _onGamePlay(game) {
        var _this2 = this;

        cc.loader.loadRes("prefabs/Games/" + game.tag, function (err, prefab) {
            if (err) {
                cc.log("Load game prefab error");
                return;
            }

            _this2.mainStageNode.active = false;
            _this2.gameStage = cc.instantiate(prefab);

            _this2.playerOneStageNode.addChild(_this2.gameStage);
            _this2.playerOneStageNode.active = true;
            var wg = _this2.playerOneStageNode.getComponent(cc.Widget);
            // wg.enabled=false
            var winSize = _this2.node.getContentSize();
            var newWidth = winSize.height;
            var newHeight = winSize.height * newWidth / winSize.width;
            // this.playerOneStageNode.scale=newWidth/winSize.width
            // this.playerOneStageNode.rotation=90
            // this.playerOneStageNode.x=-winSize.width/2+this.playerOneStageNode.height/2
        });
    },
    changeStageMode: function changeStageMode(mode) {
        this.stageMode = mode;
    },
    changeGameMode: function changeGameMode(mode) {
        this.lable.string = mode;
        this.gameMode = mode;
        this.fillGamesList();
    },
    singleMode: function singleMode() {
        this.changeGameMode("Single");
    },
    hotsMode: function hotsMode() {
        this.changeGameMode("Hots");
    },
    networkMode: function networkMode() {
        this.changeGameMode("Network");
    },
    fillGamesList: function fillGamesList() {
        var _this3 = this;

        this.gamePageView.removeAllPages();
        this._gamesList.forEach(function (game, idx) {
            var item = cc.instantiate(_this3.gamesListTemplate);

            _this3.gamePageView.addPage(item);

            var script = item.getComponent('gameListItemJs');
            script.init(game);
        });

        var pages = this.gamePageView.getPages();
        console.log(pages);
        pages.forEach(function (page, idx) {
            console.log('idx: ' + idx + ' x:' + page.x + ' width:' + page.width);
        });
    }

    // update (dt) {},

});

cc._RF.pop();