
const {ccclass, property} = cc._decorator;

@ccclass
export default class videoPlayer extends cc.Component {

    @property(cc.VideoPlayer)
    videoPlayer : cc.VideoPlayer = null;

    start () {
        this.videoPlayer.play();
    }

    getStatus (event) {
        switch (event) {
            case cc.VideoPlayer.EventType.PLAYING:
                return 'PLAYING';
            case cc.VideoPlayer.EventType.PAUSED:
                return 'PAUSED';
            case cc.VideoPlayer.EventType.STOPPED:
                return 'STOPPED';
            case cc.VideoPlayer.EventType.COMPLETED:
                return 'COMPLETED';
            case cc.VideoPlayer.EventType.META_LOADED:
                return 'META_LOADED';
            case cc.VideoPlayer.EventType.CLICKED:
                return 'CLICKED';
            case cc.VideoPlayer.EventType.READY_TO_PLAY:
                return 'READY_TO_PLAY';
            default:
                return 'NONE';
        }
    }

    onVideoPlayerEvent (sender, event) {
        if (event === cc.VideoPlayer.EventType.META_LOADED) {
            var duration = this.videoPlayer.getDuration();
        }
        else if (event === cc.VideoPlayer.EventType.CLICKED) {
            if (this.videoPlayer.isPlaying()) {
                this.videoPlayer.pause();
            } else {
                this.videoPlayer.play();
            }
        }
        else if (event === cc.VideoPlayer.EventType.READY_TO_PLAY){
            //this.videoPlayer.volume = 0;    
        }
    }
    // update (dt) {}
}
