cc.Class({
    extends: cc.Component,

    properties: {
        mapGraphics:[cc.Graphics],
        roleNode:cc.Node,
    },
    onLoad () {
        cc.director.getPhysicsManager().enabled = true;
        cc.director.getPhysicsManager().debugDrawFlags = cc.PhysicsManager.DrawBits.e_aabbBit |
    cc.PhysicsManager.DrawBits.e_pairBit |
    cc.PhysicsManager.DrawBits.e_centerOfMassBit |
    cc.PhysicsManager.DrawBits.e_jointBit |
    cc.PhysicsManager.DrawBits.e_shapeBit
    ;
        this.mapIndex = 0;
        this.lastheight = 0;
        for (var i = 0; i < this.mapGraphics.length; i++) {
            // for (var i = 0; i < 1; i++) {
            // this.mapGraphics[i].moveTo(-cc.find("Canvas").width/2,-800);
            // this.mapGraphics[i].lineTo(-cc.find("Canvas").width/2,0);
            // this.mapGraphics[i].bezierCurveTo(-cc.find("Canvas").width/3,-300-500*Math.random(),cc.find("Canvas").width/3,300,-cc.find("Canvas").width/2+cc.find("Canvas").width,0);
            // this.mapGraphics[i].lineTo(cc.find("Canvas").width/2,-800);
            // this.mapGraphics[i].lineTo(-cc.find("Canvas").width/2,-800);
            // this.mapGraphics[i].fill();
            // this.mapGraphics[i].stroke();
            this.draw(this.mapGraphics[i]);
        }
    },
    start(){
        for (var i = 1; i < this.mapGraphics.length; i++) {
            this.mapGraphics[i].node.x = this.mapGraphics[i-1].node.x+this.mapGraphics[i-1].node.width;
        };
    },
    physicsFun(ctx){
        var chain = ctx.getComponent(cc.PhysicsChainCollider);
        chain.points = ctx._impl._points;
        // this.scheduleOnce(this.app.bind(chain),0.1);
        chain.apply();
    },
    // app(){
    	// this.apply();
    // },
    draw(graphics){
    	var endY = -500*Math.random();
    	if (this.lastheight) {
    		graphics.node.y = this.lastheight-10;
    	}
    	graphics.moveTo(-cc.find("Canvas").width/2,-1800);
		graphics.lineTo(-cc.find("Canvas").width/2,0);
		graphics.bezierCurveTo(-cc.find("Canvas").width/3,parseInt(-300-800*Math.random()),cc.find("Canvas").width/3,parseInt(300-500*Math.random()),-cc.find("Canvas").width/2+cc.find("Canvas").width,parseInt(endY));
		graphics.lineTo(cc.find("Canvas").width/2,-1800);
		graphics.lineTo(-cc.find("Canvas").width/2,-1800);
		graphics.fill();
		this.lastheight = endY+graphics.node.y;
		this.physicsFun(graphics);
    },
    drawFun(){
    	this.mapGraphics[this.mapIndex].clear();
    	this.draw(this.mapGraphics[this.mapIndex]);
        if (this.mapIndex==this.mapGraphics.length-1) {
            this.mapGraphics[this.mapIndex].node.x = this.mapGraphics[this.mapIndex-1].node.x+this.mapGraphics[this.mapIndex].node.width;
            this.mapIndex = 0;
        }
        else if (!this.mapIndex) {
            this.mapGraphics[this.mapIndex].node.x = this.mapGraphics[this.mapGraphics.length-1].node.x+this.mapGraphics[this.mapIndex].node.width;
            this.mapIndex++;
        }
        else{
            this.mapGraphics[this.mapIndex].node.x = this.mapGraphics[this.mapIndex-1].node.x+this.mapGraphics[this.mapIndex].node.width;
            this.mapIndex++;
        }
    },
    update (dt) {
        if (this.roleNode.x-this.mapGraphics[this.mapIndex].node.x>=cc.find("Canvas").width) {
            this.drawFun();
        }
    },
});
