/**
 * 打字机效果，支持1层的richtext控制标签color和size
 * Auth: MakeBestGame
 *
 * @namespace effectPrinter[creatorComponent]
 * @example
 * "神创造<color=#0099FF>万物</color>，智慧<size=80>生物</size>成了人"
 * 注意，多层标签不支持：
 * "<size =80>神创造<color=#0099FF>万物</color>，智慧<size=80>生物</size>成了人"
 *
 * 登记了‘fastForward’事件，可以通过
 * cc.systemEvent.emit('fastForward', 0.01);
 * 以0.01秒的速度播放
 *
 */

cc.Class({
  extends: cc.Component,

  properties: {
    delay: {
      default: 0.1,
      tooltip: '打字字间隔时间，单位：秒',
    },
    _string: {
      default: '',
    },
    string: {
      tooltip: '打印内容文字',
      get() {
        return this._string;
      },
      set(value) {
        this._string = value;
        this.reset();
      },
    },
    finish: {
      default: null,
      type: cc.Component.EventHandler,
      tooltip: '打字完成回调',
    },
  },

  onLoad() {
    let com = this.node.getComponent(cc.Label);
    if (!com) {
      com = this.node.getComponent(cc.RichText);
    }
    this._labelCom = com;
    cc.systemEvent.on(
      'fastForward',
      (d) => {
        this.delay = d;
      },
      this.node,
    );
  },

  reset() {
    this._stringArr = this._string.split('');
    this._t = 0;
    if (this._labelCom) {
      this._labelCom.string = '';
    }
    delete this._rememberAdd;
  },
  update(dt) {
    if (!this._labelCom) return;
    if (!this._stringArr || this._stringArr.length <= 0) return;
    this._t += dt;
    if (this._t >= this.delay) {
      let char = this._stringArr.shift();

      if (char === '<') {
        // richtext控制字符
        let s = char;
        let end;
        while (end !== '>') {
          end = this._stringArr.shift();
          s += end;
          if (this._stringArr.length <= 0) break;
        }
        const isEnd = s.indexOf('</');
        if (isEnd !== -1) {
          // 分析到结束符
          if (this._rememberAdd) {
            this._labelCom.string = this._labelCom.string.substring(0, this._labelCom.string.length - this._rememberAdd.length);
            delete this._rememberAdd;
          }
        }
        this._labelCom.string += s;
        ['color', 'size', 'i', 'u'].forEach((x) => {
          if (isEnd === -1 && s.indexOf(x) !== -1) {
            char = this._stringArr.shift();
            this._labelCom.string += char;
            this._rememberAdd = `</${x}>`;
            this._labelCom.string += this._rememberAdd;
          }
        });
      } else {
        if (this._rememberAdd) {
          // 先去掉前面
          this._labelCom.string = this._labelCom.string.substring(0, this._labelCom.string.length - this._rememberAdd.length);
        }
        this._labelCom.string += char;
        if (this._rememberAdd) {
          // 先去掉前面
          this._labelCom.string += this._rememberAdd;
        }
      }
      // logger.log('[effectPrinter] check:', this._labelCom.string);
      this._t = 0;
      if (this._stringArr.length === 0) {
        if (this.finish) {
          if (this.finish instanceof cc.Component.EventHandler) {
            this.finish.emit();
          } else {
            this.finish();
          }
        }
      }
    }
  },
});
