const {ccclass, property} = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    @property({ type: cc.Node, tooltip: ''})
    cocos: cc.Node = null;

    @property({ type: cc.Label, tooltip: ''})
    lbtxt: cc.Label = null;

    start () {
        // init logic
        this.label.string = this.text;
    }

    onLoad(){
        cc.director.getPhysicsManager().enabled = true;
    }

    isTouch = false;

    onTouch(){
        if (this.isTouch){
            this.cocos.active = true;
            this.isTouch = false;
            this.lbtxt.string = '隐藏';
        }else{
            this.isTouch = true;
           this.cocos.active = false;
           this.lbtxt.string = '显示';
        }
    }
}
