import { _decorator, Component, Node, director, game, find } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Test')
export class Test extends Component {
    /* class member could be defined like this */
    // dummy = '';

    /* use `property` decorator if your want the member to be serializable */
    // @property
    // serializableDummy = 0;

    private camList:{[key:number]:Node} = {}
    private curID:number = 1

    async start () {
        // Your initialization goes here.
        game.addPersistRootNode(this.node)
        await this.loadScene()

        this.camList[1] = find('Camera01')
        this.camList[2] = find('Camera02')
        this.camList[3] = find('Camera03')
        this.camList[4] = find('Camera04')
    }

    // update (deltaTime: number) {
    //     // Your update function goes here.
    // }

    // 直接加载场景
    async loadScene():Promise<void>{
        let promise = new Promise<void>( resolve => {
            director.loadScene('main', () => {
                resolve()
            })
        })

        return promise
    }

    onClick(){
        this.camList[this.curID].active = false
        this.curID++
        this.curID = this.curID > 4 ? 1 : this.curID
        this.camList[this.curID].active = true
    }
}
