var SCOPE_INFO = 'scope.userInfo'
 var httpUrl = 'https://game.pabble.net'
//var httpUrl = 'http://120.79.61.113:8860'
module.exports = {
    getCache : function(){
      var openid = wx.getStorageSync('openid');
      var session_key = wx.getStorageSync('session_key');
      
      var userinfo = wx.getStorageSync('userinfo');
      console.log('getCache ', openid, session_key, userinfo)
      if (!openid || !session_key || !userinfo) {
        return false;
      }
      try{
        this.setData(openid, session_key, JSON.parse(userinfo));
      }catch(e){
        return false
      }
      return true;
    },

    setData : function(openid,key,userinfo){
       console.log('setData:',openid,',sessionKey:',key)
       
       this.openid = openid;
       this.session_key = key;
       this.userinfo = userinfo;
       wx.setStorageSync('openid',openid);
       wx.setStorageSync('session_key', key);
       wx.setStorageSync('userinfo', JSON.stringify(userinfo));
       console.log('setData:',arguments)
       
    },
    //设置右上角分享时的分享内容
    autoShare:function(){
      wx.onShareAppMessage(function(){
        return{
          title: '快来一起玩欢乐堆2048吧',
          imageUrl: wxDownloader.REMOTE_SERVER_ROOT + '/wechatshare.png'
        }
      })
    },

    //清除旧的下载资源
    cleanOldAssets:function(cb){
      this.autoShare();
     // cb();
      var wfu = require('WxFileUtils');
      console.log('cleanOldAssets path:',wx.env.USER_DATA_PATH)
      var self = this

      var isLogin = false;
      var mainFile = wx.env.USER_DATA_PATH + '/res'
      var isExe = false;
      var remove = function(){
        wfu.removeAllDir(wx.env.USER_DATA_PATH + '/res', function (i) {
          // console.log('删除config文件夹成功:' + i)
          isExe = true;
          wfu.removeDir(mainFile, function (p, t) {
            // console.log('检测resources:', t);
            if (t && !isLogin) {
              cb();
              isLogin = true;
            }
          })
        }, 0)
      }
      setTimeout(remove,1000)

      setTimeout(function(){ //微信里有个BUG，如果先删除文件，然后文件后面再下载，会进入idle状态，这个检查就是防止这个状态
        if (!isExe){
          cb();
          isLogin = true;
        }
      },10000)
    },
    //初始化，传入登陆成功的回调
    init : function(callback){
      wx.showShareMenu({
        withShareTicket: true
      })
      
      this.loginCallback = callback;
    },

    isSimulator : function(){
      this.systemInfo = wx.getSystemInfoSync()
      return this.systemInfo.platform == 'devtools'
    },

    //显示登陆按钮
    showInfoButton: function () { 

    if (this.infoButton) {
      this.infoButton.show();
      return;
    }
    this.systemInfo = wx.getSystemInfoSync()
    var sx = parseInt(this.systemInfo.screenWidth) / 1334.0
    var sy = parseInt(this.systemInfo.screenHeight) / 750.0
    var width = 192;
    var height = 73

    var left = this.systemInfo.screenWidth / 2 - width / 2
    var top = this.systemInfo.screenHeight * 0.8 - height / 2
    let button = wx.createUserInfoButton({
      type: 'image',
      image: wxDownloader.REMOTE_SERVER_ROOT+"/btn_weixin.png",
      style: {
        left: left,
        top: top,
        width: width,
        height: height,
        backgroundColor: '#ffffff',
        textAlign: 'center',
        fontSize: 16,
        borderRadius: 4
      }
    })
    button.show();
    button.onTap(function (res) {
      if (res['userInfo']) {
        this.userInfo = res['userInfo']
        this.getOpenId(null);
      }
      console.log('button ontap:', res)
    }.bind(this))
    this.infoButton = button
  },
  //隐藏登陆按钮
  hideInfoButton: function () {
    if (this.infoButton) {
      this.infoButton.hide();
    }
  },

  //远程服务器登陆
  getOpenId: function () {
    if (this.islogin) {
      console.log('this.islogin:', this.islogin)
      return;
    }
    console.log('Interface init:', this.config)
    this.islogin = true;
    var self = this;
    wx.login({
      success: function (res) {
        if (res.code) {
          //发起网络请求
          wx.request({
            url: httpUrl + '/login?code='+res.code,
            data: {
              code: res.code
            },
            success: function (res) {
              console.log('request:', res);
              if (res.statusCode == 200) {
                self.infoButton.hide();
                self.openId = res.data.openid
                self.sessionKey = res.data.session_key
                self.setData(res.data.openid, res.data.session_key, self.userInfo)
                self.loginCallback(self.openId, self.sessionKey, JSON.stringify(self.userInfo));
              } else {
                self.islogin = false;
              }
            },
            fail: function () {
              self.islogin = false;
            }
          })
        } else {
          self.islogin = false;
          console.log('登录失败！' + res.errMsg)
        }
      }
    });
  },

  //分享信息，带判断不同群
  shareMessage : function(title,img,callback){
      console.log('shareMessage: title:',title);

      // callback(null, { openGid: '0'})
      var uncodeUrl = httpUrl+'encode?iv={0}&sessionKey={1}&encryptedData={2}'
      var self = this;
      var share = {
        title: title,
        imageUrl: img,
        success: function (res) {
          //  callback(null,res)
          if(cc.isWatch){
            return;
          }
          console.log('分享成功:', res)
           if(res.shareTickets){
             wx.getShareInfo({
               shareTicket: res.shareTickets[0],
               success: function (res) { 
                 var session_key = encodeURIComponent(wx.getStorageSync('session_key'));
                 var iv = encodeURIComponent(res.iv)
                 var encryptedData = encodeURIComponent(res.encryptedData);
                 console.log('iv:'+iv,'session_key'+session_key,'data:'+encryptedData);
                 var url = uncodeUrl.format(iv,session_key,encryptedData);;
                 console.log('encodeurl:',url);
                 wx.request({
                   url: url,
                   success : function(res){
                     console.log('uncode data=', res.data);
                      if(res.data.code == 0){
                        callback(null, { openGid: res.data.data.openGId})
                      } else {
                        callback(res.data.code);
                      }
                   },
                   fail:function(){
                     callback(-1);
                   }
                 })
                 },
               fail: function (res) { console.log('获取分享失败:', res), callback(-1); },
               complete: function (res) { console.log('获取分享完成:', res) }
             })
           }
        },
        fail: function (err) {
          if (cc.isWatch) {
            return;
          }
           callback(err);
          console.log('fail:', err)
        }
      }
      console.log('cc.iswatch:',cc.isWatch);
      if(cc.isWatch){
        
        callback(null, {openGid :'1'});
      }

      wx.shareAppMessage(share)
      if(this.isSimulator()){
         callback(null,null);
      }
    },
    hideGameClub: function() {

    },
    updateBanner(height,bid){
      // height = 160;
      var canvas = cc.game.canvas
      var size = cc.director.getWinSizeInPixels()
      this.systemInfo = wx.getSystemInfoSync()
      var h = height / size.height * this.systemInfo.screenHeight
      var bannerAd = wx.createBannerAd({
        adUnitId: bid,
        style: { left: (this.systemInfo.screenWidth -300)/2, top: this.systemInfo.screenHeight - 90, width: 300, height: 86}
      })
      bannerAd.onResize(function(){
        console.log('onResize:',h,arguments);
        if (this.bannerAd) {
          this.bannerAd.destroy();
        }
        this.bannerAd = bannerAd;
      })
      bannerAd.show();
    },
    showBanner: function(height,bid) {
      this.updateBanner(height,bid);
    },
    hideBanner: function() {
      if(this.bannerAd){
        this.bannerAd.hide();
      }
    },
    showVideoButton: function() {
      
    },
    hideVideoButton: function() {

    },
    loadVideo:function(){
      this.videoAd = wx.createRewardedVideoAd({ adUnitId: 'adunit-7e7a16db3d51e944' })
      this.videoAd.onLoad(function(res){
        console.log('视频加载结果:',res);
      })
    },
    showVideo:function(cb){
      var self = this;
      this.videoAd.onClose(function (res){
        console.log('点击关闭:',res.isEnded);
        cb(res.isEnded)
      })
      this.videoAd.show()
      // let videoAd = wx.createRewardedVideoAd({ adUnitId: 'adunit-7e7a16db3d51e944' })
      // videoAd.load().then(() => videoAd.show()).catch(err => console.log(err.errMsg))
    },
    //更多游戏 在游戏内跳转到别的小程序或预览图片(可以长按识别)
    showMoreGame:function(){
      if (wx.navigateToMiniProgram != undefined) {
        wx.navigateToMiniProgram({ appId: 'wx80309971d0c4db96' });
      } else {
        wx.previewImage({ urls: ['https://static.xiaoyouxi777.com/box/images/label/doudou.jpg'] })
      }
    },
    //显示游戏圈
    showGameClub: function () {
      // this.systemInfo = wx.getSystemInfoSync()
      // var height = this.systemInfo.screenHeight;
      // console.log("showGameClub------------------")
      // if (!this.clubButton){
      //   this.clubButton = wx.createGameClubButton({
      //     type: "image",
      //     image: "https://aixiaoxiao.xiaoyouxi777.com/quan.png",
      //     icon:"white",
      //     style: {
      //       left: 0,
      //       top: 0.4*height,
      //       width: 50,
      //       height: 50,
      //       backgroundColor: "ff0000",
      //       textAlign: "left"
      //     }
      //   })
      // }
      // this.clubButton.show();
    },
    hideGameClub: function() {
      // if (this.clubButton) {
      //   this.clubButton.hide();
      // }
    },
    //系统的提示文字
    showToast(str){
      wx.showToast({
        title: str,
      })
    }
}