var fs = wx.getFileSystemManager();
module.exports = {
  removeDir:function(file, cb) {
    var errmsg = fs.access({
      path: file,
      success: function (res) {
        // console.log('main file access:', file)
        var a = fs.rmdir({
          dirPath: file,
          recursive: false,
          complete: function (r) {
            // console.log('删除目录结果', file, r)
            cb(file, true)
          }
        })
      }, fail: function (err) {
        // console.log('main file err:', file)
        cb(file, false)
      }
    })
  },

  removeAllDir: function (dir, cb, order) {
    var self = this;
    fs.readdir({
      dirPath: dir,
      success: function (res) {
        // console.log('files:', res.files);
        var hasFold = false

        for (var i = 0; i < res.files.length; i++) {
          var file = dir + '/' + res.files[i];
          var stat = fs.statSync(file)
          if (stat.isFile()) {
            // console.log('删除文件' + file);
            fs.unlink({
              filePath: file
            })
            // console.log('删除文件1' + file);
            // 
          } else {
            self.removeAllDir(file, function (d) {
              // console.log('清空文件成功:',d)
              self.removeDir(d, cb)
            }, ++order)
            hasFold = true
          }
        }
        if (!hasFold) {
          cb(dir);
        }
      },
      fail: function (errMsg) {
        // console.log('errMsg:', errMsg);
      },
      complete: function () {
        // console.log('complete:' + order);
      }
    })
  },
}