import WeixinAudio from "../weixin/WeixinAudio";
import WeixinUtils from "../weixin/WeixinUtils";


export default class DomAudioGroup {
    _audioUrl = null;
    _endCallback = null;

    _domAudio = null;

    constructor(audioUrl) {
        this._audioUrl = audioUrl;

        this._domAudio = new Audio(this._audioUrl);
        this._domAudio.loop = false;
        this._domAudio.crossOrigin = 'anonymous';
        this._domAudio.addEventListener('ended', this.endPlay.bind(this));
    }

    play() {
        this.close();

        if(WeixinUtils.isWeiXin()) {
            new WeixinAudio(this.playDomAudio,this);
        }else {
            this.playDomAudio();
        }
    }

    playDomAudio() {
        this._domAudio.load();
        this._domAudio.play();
    }

    endPlay(e){
        if(this._endCallback) {
            this._endCallback.call();
        }
    }

    close() {
        this._domAudio.pause();
    }
}