import DomAudioGroup from "./DomAudioGroup";



export default class DomAudioGroupInstance {
    static __instance;

    _domAudioDict = null;

    constructor() {
        this._domAudioDict = {};
    }

    /**@type {DomAudioGroupInstance} */
    static get instance() {
        if(!DomAudioGroupInstance.__instance) {
            DomAudioGroupInstance.__instance = new DomAudioGroupInstance();
        }
        return DomAudioGroupInstance.__instance;
    }

    play(/**@type {string}*/audioUrl,endCallback = null,isStopAll = true) {
        if(isStopAll) {
            this.stopAll();
        }

        let domAudioGroup = this._domAudioDict[audioUrl];
        if(!domAudioGroup) {
            domAudioGroup = new DomAudioGroup(audioUrl);
            this._domAudioDict[audioUrl] = domAudioGroup;
        }
        domAudioGroup._endCallback = endCallback;
        domAudioGroup.play();
    }

    stopAll() {
        for(let k in this._domAudioDict) {
            let domAudioGroup = this._domAudioDict[k];
            if(domAudioGroup) {
                domAudioGroup.close();
            }
        }
    }

}