import WeixinAudio from "../weixin/WeixinAudio";
import WeixinUtils from "../weixin/WeixinUtils";


export default class WebAudioGroup {
    _audioUrl = null;
    _endCallback = null;

    __audioWeb = null;
    /**@type {number} */
    __audioCurrent = 0;

    _domAudio = null;

    _autoPlay = true;

    constructor(audioUrl) {
        this._audioUrl = audioUrl;

        cc.loader.load(this._audioUrl,(err,audio)=>{
            if(err) {
                cc.error("[AudioGroup.js]load mp3 url error=>",err);
            }else {
                this.__audioWeb = audio;
                if(this._autoPlay) {
                    this.play();
                }
            }
        });
    }

    play() {
        this.close();
        
        if(this.__audioWeb) {
            if(WeixinUtils.isWeiXin()) {
                new WeixinAudio(this.playWebAudio,this);
            }else {
                this.playWebAudio();
            }
        }else {
            this._autoPlay = true;
        }
    }

    playWebAudio() {
        this.__audioCurrent = cc.audioEngine.play(this.__audioWeb,false,1);
        if(this._endCallback) {
            cc.audioEngine.setFinishCallback(this.__audioCurrent, ()=>{
                this._endCallback.call();
            });
        }
    }

    close() {
        cc.audioEngine.stop(this.__audioCurrent);
    }
}