import WebAudioGroup from "./WebAudioGroup";



export default class WebAudioGroupInstance {
    static __instance;

    _webAudioDict = null;

    constructor() {
        this._webAudioDict = {};
    }

    /**@type {WebAudioGroupInstance} */
    static get instance() {
        if(!WebAudioGroupInstance.__instance) {
            WebAudioGroupInstance.__instance = new WebAudioGroupInstance();
        }
        return WebAudioGroupInstance.__instance;
    }

    play(/**@type {string}*/audioUrl,endCallback = null,isStopAll = true) {
        if(isStopAll) {
            this.stopAll();
        }

        let webAudioGroup = this._webAudioDict[audioUrl];
        if(!webAudioGroup) {
            webAudioGroup = new WebAudioGroup(audioUrl);
            this._webAudioDict[audioUrl] = webAudioGroup;
        }
        webAudioGroup._endCallback = endCallback;
        webAudioGroup.play();
    }

    stopAll() {
        for(let k in this._webAudioDict) {
            let webAudioGroup = this._webAudioDict[k];
            if(webAudioGroup) {
                webAudioGroup.close();
            }
        }
    }

}