// panel/index.js, this filename needs to match the one registered in package.json
Editor.Panel.extend({
  // css style for panel
  style: `
    #editorA {
      width: 100%;
      height: 400px;
    }
  `,

  // html template for panel
  template: `
    
      <div id="editorA">
      {
      "showapi_res_error": "",
      "showapi_res_id": "7c9bf9b98da546e99e9cf500d28fc04b",
      "showapi_res_code": 0,
      "showapi_res_body": {
      "ret_code": 0,
      "pagebean": {
      "cur_song_num": 100,
      "code": 0,
      "day_of_year": "",
      "song_begin": 0,
      "totalpage": 1
      
      }
      </div>
  `,

  // element and variable binding
  $: {
    editorA: '#editorA',
    box: '#box',
  },

  // method executed when template and styles are successfully loaded and initialized
  ready () {
    window.packageRoot = 'packages://test/';
    const ace      = Editor.require('packages://test/src-min/ace.js');
    const language_tools      = Editor.require('packages://test/src-min/ext-language_tools.js');

    ace.config.set("basePath",Editor.url('packages://test/src-min/', 'utf8'))
    var editor = ace.edit(this.$editorA);
    editor.setOptions({
      // 默认:false
      wrap: true, // 换行
      // autoScrollEditorIntoView: false, // 自动滚动编辑器视图
      enableLiveAutocompletion: true, // 智能补全
      enableSnippets: true, // 启用代码段
      enableBasicAutocompletion: true, // 启用基本完成 不推荐使用
    });
    // 设置主题  cobalt monokai
    editor.setTheme("ace/theme/xcode");
    // 设置编辑语言
    editor.getSession().setMode("ace/mode/javascript");
    editor.setReadOnly(false)
    editor.getSession().setTabSize(2);
    editor.setValue("the new text here\n\n");
  },

  // register your ipc messages here
  messages: {
    'test:hello' (event) {
      // this.$label.innerText = 'Hello!';
    }
  }
});