(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/launch.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'e53e6YiUd9FJLf8yIQu1n47', 'launch', __filename);
// launch.js

'use strict';

cc.Class({
    extends: cc.Component,

    properties: {
        content: cc.Node,
        prefab: cc.Prefab
    },

    start: function start() {
        var _self = this;

        wx.onMessage(function (data) {
            if (data.nickName && data.avatarUrl) {
                _self.showUserData(data.nickName, data.avatarUrl);
                // fill the content by the blank targets.
                (function () {
                    for (var i = 0; i < 5; i++) {
                        var node = cc.instantiate(_self.prefab);
                        node.parent = _self.content;
                    }
                })();
            };
        });

        wx.getFriendCloudStorage({
            success: function success(res) {
                for (var i = 0; i < 5; i++) {
                    var friend = res.data[i];
                    if (!_self.preSettingData(friend, ' stop getting friends\' infos')) {
                        return;
                    }
                }
            },
            fail: function fail(res) {
                console.log(res);
            }
        });
    },
    showUserData: function showUserData(nickName, avatarUrl) {
        var node = cc.instantiate(this.prefab);
        node.parent = this.content;
        var userName = node.getChildByName('userName').getComponent(cc.Label);
        var userIcon = node.getChildByName('mask').children[0].getComponent(cc.Sprite);

        userName.string = nickName;
        console.log(nickName + '\'s info has been getten.');
        cc.loader.load({
            url: avatarUrl, type: 'png'
        }, function (err, texture) {
            if (err) console.error(err);
            console.log(texture);
            userIcon.spriteFrame = new cc.SpriteFrame(texture);
        });
    },
    preSettingData: function preSettingData(user, str) {
        if (!user) {
            console.log(str);
            return false;
        }
        var nickName = user.nickname;
        var avatarUrl = user.avatarUrl;
        this.showUserData(nickName, avatarUrl);
        return true;
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=launch.js.map
        