/**
 * author: xuao
 * time: 2018/04/09
 * func: 消息事件管理
 */

var eventMap = {};

window.game = window.game || {};

/**
 * 注册全局事件
 * @param {*} eventName         事件名（String）
 * @param {*} callback          回调事件
 * @param {*} thisObj           回调函数绑定对象
 */
game.on = function(eventName, callback, thisObj){
    var list  = eventMap[eventName];
    if(list == null){
        list = [];
        eventMap[eventName] = list;
    }

    var len = list.length;
    for(var i = 0; i < len; i++){
        var EI = list[i];
        if(EI["callback"] == callback && EI["thisObj"] == thisObj){
            cc.warn("事件【" + eventName +"】重复监听");
        }
    }

    if(callback == null){
        cc.error("事件【" + eventName +"回调函数为空");
    }

    list.push({callback: callback, thisObj: thisObj});
},

/**
 * 移除全局事件
 * @param {*} eventName         事件名（String）
 * @param {*} callback          回调事件
 * @param {*} thisObj           回调函数绑定对象
 */
game.off = function(eventName, callback, thisObj){
    var list = eventMap[eventName];
    if(list == null){
        cc.error("事件【" + eventName +"】没有注册过");
    }

    var len = list.length;
    for(var i = 0; i < len; i++){
        var EI = list[i];
        if(EI["callback"] == callback && EI["thisObj"] == thisObj){
            list.splice(i, 1);
            break;
        }
    }

    if(list.length == 0){
        delete eventMap[eventName];
    }
}

/**
 * 发送全局事件
 * @param {*} eventName          事件名
 * @param {*} data               携带数据
 */
game.dispatchEvent = function(eventName, data){
    var list = eventMap[eventName];

    if(list == null){
        cc.error("事件【" + eventName + "】没有被监听过");
    }

    var len = list.length;
    for(var i = 0; i < len; i++){
        var EI = list[i];
        EI.callback.call(EI.thisObj, data);
    }
}