import { _decorator, Component, Node, CameraComponent, Vec2, v3 } from "cc";
const { ccclass, property } = _decorator;

@ccclass("test")
export class test extends Component {
    @property(Node)
    player: Node = null;
    @property(Node)
    ui: Node = null;
    @property(CameraComponent)
    camera: CameraComponent = null;
    @property(Node)
    cameraNode: Node = null;
    @property(Node)
    enemy: Node = null;
    lateUpdate() {
        let pos = this.enemy.getWorldPosition();
        this.camera.convertToUINode(pos, this.ui.parent, pos);
        if (pos.x > 350 || pos.x < -350 || pos.y < -600 || pos.y > 600) {

            pos.x = (pos.x < -350) ? -350 : pos.x;
            pos.x = (pos.x > 350) ? 350 : pos.x;
            pos.y = (pos.y < -600) ? -600 : pos.y;
            pos.y = (pos.y > 600) ? 600 : pos.y;

        }




        this.ui.setPosition(pos);

        let pos2 = this.player.getWorldPosition();
        this.cameraNode.setWorldPosition(v3(pos2.x, 0, pos2.z));
    }
}
