
const {ccclass, property} = cc._decorator;

@ccclass
export default class TileMapCreator extends cc.Component {

    @property(cc.TiledMap)
    tiledMap: cc.TiledMap = null;
    @property(cc.Camera)
    mainCamera:cc.Camera = null;

    start ()
    {
        this.node.on(cc.Node.EventType.TOUCH_START, this.onMouseDown, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.onMouseUp, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onMouseMove, this);
        this.node.on(cc.Node.EventType.MOUSE_WHEEL, this.onMouseWheel, this);

        let bgLayer = this.tiledMap.getLayer('bg')
        let wallLayer = this.tiledMap.getLayer('wall')

        let size = bgLayer.getLayerSize()
        for (let i = 0; i < size.width; i++)
        {
            for (let j = 0; j < size.height; j++)
            {
                let gid = bgLayer.getTileGIDAt(cc.v2(i,j))
                if (gid != 0)
                {
                    let tile = bgLayer.getTiledTileAt(i,j,true)
                    
                }              
            }
        }

        size = wallLayer.getLayerSize()
        for (let i = 0; i < size.width; i++)
        {
            for (let j = 0; j < size.height; j++)
            {
                let gid = wallLayer.getTileGIDAt(cc.v2(i,j))
                if (gid != 0)
                {
                    let tile = wallLayer.getTiledTileAt(i,j,true)
                    
                }              
            }
        }
    }

    controlCamera = false
    onMouseDown(event)
    {
        this.controlCamera = true
    }
    onMouseUp(event)
    {
        this.controlCamera = false
    }
    onMouseMove(event)
    {
        if (this.controlCamera)
        {
            let dir = cc.v2(-event.getDelta().x,-event.getDelta().y)
            this.mainCamera.node.position = this.mainCamera.node.position.add(dir)
        }
    }
    onMouseWheel(event)
    {
        this.mainCamera.zoomRatio = this.mainCamera.zoomRatio + (event.getScrollY()>0?0.05:-0.05)
    }
}
