// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    private _audioSource: cc.AudioSource = null
    // LIFE-CYCLE CALLBACKS:
    private _musicId = -1
    onLoad () {
    }
    
    start () {
        // this._audioSource = this.node.getComponent(cc.AudioSource)
        // this._audioSource.volume = 0.5
        cc.loader.loadRes('lobbyBg',cc.AudioClip,(err,sound:cc.AudioClip)=>{
            if(err){
                console.log('err');
                return
            }
            cc.audioEngine.stopAll()
            this._musicId = cc.audioEngine.playMusic(sound,true)
        })
        
    }
    onDestroy(){
        cc.audioEngine.stop(this._musicId)
    }
    sliderCall(target: cc.Slider) {
        console.log(target.progress);
        // this._audioSource.volume = target.progress
        // cc.audioEngine.setMusicVolume(target.progress)
        cc.audioEngine.setVolume(this._musicId,target.progress)

    }
    clickToMain(){
        cc.director.loadScene('helloworld')
    }
}
