cc.Class({
    extends: cc.Component,
    properties: {
        camera: cc.Camera,
        spFrame: cc.Node,
        panel_btns: cc.Node,
        btn_close: cc.Node,
        frame_photo:cc.Node,
    },

    init() {
        var widget = this.node.getComponent(cc.Widget);
        widget.target = cc.SceneCanvas;
        this.frame_photo.active = false;
        this.spFrame_h = this.spFrame.height;
        let texture = new cc.RenderTexture();
        let gl = cc.game._renderContext;
        texture.initWithSize(cc.visibleRect.width, cc.visibleRect.height, gl.STENCIL_INDEX8);
        this.camera.targetTexture = texture;
        this.texture = texture;
    },
    initImageNative() {
        var data = this.texture.readPixels();
        this._width = this.texture.width;
        this._height = this.texture.height;
        var picData = this.filpYImage(data, this._width, this._height);
        return picData;
    },
    showSpriteNative(picData,callback) {
        this.node.active = true;
        this.frame_photo.active = true;
        let texture = new cc.Texture2D();
        texture.initWithData(picData, cc.Texture2D.RGBA8888, this._width, this._height);
        let spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(texture);

        let sprite = this.spFrame.getComponent(cc.Sprite);
        sprite.spriteFrame = spriteFrame;
        this.spFrame.width = this.spFrame_h * this._width / this._height;
        this.spFrame.height = this.spFrame_h;
        callback && callback();
    },
    begin() {
        this.panel_btns.active = false;
        this.capture();
    },
    capture(){
        this.init();
        this.scheduleOnce(() => {
            let img = this.initImageNative();
            this.showSpriteNative(img,this.capture_wx.bind(this));
        }, 0.2);
    },
    capture_wx() {
        this.scheduleOnce(() => {
            var canvas = cc.game.canvas;
            this.saveFile(canvas);
        }, 0.2);
    },
    saveFile(tempcanvas) {
        if (CC_WECHATGAME) {
            let data = {
                x: 0,
                y: 0,
                width: tempcanvas.width,
                height: tempcanvas.height,
                destWidth: tempcanvas.width,
                destHeight: tempcanvas.height,
                fileType: 'png',
                quality: 1.0,
            };
            this.tempFilePath = tempcanvas.toTempFilePathSync(data);
            this.panel_btns.active = true;
            this.panel_btns.getChildByName("wx_btns").active = true;
        }
    },
    sharePhoto() {
        wx.shareAppMessage({
            imageUrl: this.tempFilePath,
        });
    },

    saveImageToPhotosAlbum() {
        wx.saveImageToPhotosAlbum({
            filePath: this.tempFilePath,
            success: function (res) {
                cc.iwx.showToast(cc.languageMgr.getString('baocuntupian'), 1500);
            },
            fail: function (err) {
                console.error(err);
            },
        });
    },

    onClick(event, customData) {
        switch (event.currentTarget.name) {
            case "btn_save":
                cc.iwx.showToast(cc.languageMgr.getString('baocuntupian'), 3000);
                break;
            case "btn_share":
                this.sharePhoto();
                break;
            case 'btn_close':
                this.node.active = false;
                break;
        }
    },
    filpYImage(data, width, height) {
        let picData = new Uint8Array(width * height * 4);
        let rowBytes = width * 4;
        for (let row = 0; row < height; row++) {
            let srow = height - 1 - row;
            let start = srow * width * 4;
            let reStart = row * width * 4;
            for (let i = 0; i < rowBytes; i++) {
                picData[reStart + i] = data[start + i];
            }
        }
        return picData;
    },
});
