"use strict";
cc._RF.push(module, '230e6bqTn9Gm5JPx3/gJtrg', 'icapture_wechat');
// testdemo/icapture_wechat.js

'use strict';

cc.Class({
    extends: cc.Component,
    properties: {
        camera: cc.Camera,
        spFrame: cc.Node,
        panel_btns: cc.Node,
        btn_close: cc.Node,
        frame_photo: cc.Node
    },

    init: function init() {
        var widget = this.node.getComponent(cc.Widget);
        widget.target = cc.SceneCanvas;
        this.frame_photo.active = false;
        this.spFrame_h = this.spFrame.height;
        var texture = new cc.RenderTexture();
        var gl = cc.game._renderContext;
        texture.initWithSize(cc.visibleRect.width, cc.visibleRect.height, gl.STENCIL_INDEX8);
        this.camera.targetTexture = texture;
        this.texture = texture;
    },
    initImageNative: function initImageNative() {
        var data = this.texture.readPixels();
        this._width = this.texture.width;
        this._height = this.texture.height;
        var picData = this.filpYImage(data, this._width, this._height);
        return picData;
    },
    showSpriteNative: function showSpriteNative(picData, callback) {
        this.node.active = true;
        this.frame_photo.active = true;
        var texture = new cc.Texture2D();
        texture.initWithData(picData, cc.Texture2D.RGBA8888, this._width, this._height);
        var spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(texture);

        var sprite = this.spFrame.getComponent(cc.Sprite);
        sprite.spriteFrame = spriteFrame;
        this.spFrame.width = this.spFrame_h * this._width / this._height;
        this.spFrame.height = this.spFrame_h;
        callback && callback();
    },
    begin: function begin() {
        this.panel_btns.active = false;
        this.capture();
    },
    capture: function capture() {
        var _this = this;

        this.init();
        this.scheduleOnce(function () {
            var img = _this.initImageNative();
            _this.showSpriteNative(img, _this.capture_wx.bind(_this));
        }, 0.2);
    },
    capture_wx: function capture_wx() {
        var _this2 = this;

        this.scheduleOnce(function () {
            var canvas = cc.game.canvas;
            _this2.saveFile(canvas);
        }, 0.2);
    },
    saveFile: function saveFile(tempcanvas) {
        if (CC_WECHATGAME) {
            var data = {
                x: 0,
                y: 0,
                width: tempcanvas.width,
                height: tempcanvas.height,
                destWidth: tempcanvas.width,
                destHeight: tempcanvas.height,
                fileType: 'png',
                quality: 1.0
            };
            this.tempFilePath = tempcanvas.toTempFilePathSync(data);
            this.panel_btns.active = true;
            this.panel_btns.getChildByName("wx_btns").active = true;
        }
    },
    sharePhoto: function sharePhoto() {
        wx.shareAppMessage({
            imageUrl: this.tempFilePath
        });
    },
    saveImageToPhotosAlbum: function saveImageToPhotosAlbum() {
        wx.saveImageToPhotosAlbum({
            filePath: this.tempFilePath,
            success: function success(res) {
                cc.iwx.showToast(cc.languageMgr.getString('baocuntupian'), 1500);
            },
            fail: function fail(err) {
                console.error(err);
            }
        });
    },
    onClick: function onClick(event, customData) {
        switch (event.currentTarget.name) {
            case "btn_save":
                cc.iwx.showToast(cc.languageMgr.getString('baocuntupian'), 3000);
                break;
            case "btn_share":
                this.sharePhoto();
                break;
            case 'btn_close':
                this.node.active = false;
                break;
        }
    },
    filpYImage: function filpYImage(data, width, height) {
        var picData = new Uint8Array(width * height * 4);
        var rowBytes = width * 4;
        for (var row = 0; row < height; row++) {
            var srow = height - 1 - row;
            var start = srow * width * 4;
            var reStart = row * width * 4;
            for (var i = 0; i < rowBytes; i++) {
                picData[reStart + i] = data[start + i];
            }
        }
        return picData;
    }
});

cc._RF.pop();