const SubgameManager = require('SubgameManager');

cc.Class({
    extends: cc.Component,

    properties: {
        downloadBtn: {
            default: null,
            type: cc.Node
        },
        downloadLabel: {
            default: null,
            type: cc.Label
        }
    },

    onLoad: function () {
        const name = 'subgame';    
        this.logand("进入游戏大厅")
        //判断子游戏有没有下载
        if (SubgameManager.isSubgameDownLoad(name)) {
            SubgameManager.enterSubgame('subgame');
            // 已下载，判断是否需要更新
            SubgameManager.needUpdateSubgame(name, (success) => {
                if (success) {
                    this.downloadLabel.string = "子游戏需要更新";
                } else {
                    this.downloadLabel.string = "子游戏不需要更新";
                    SubgameManager.enterSubgame('subgame');
                }
            }, () => {
                cc.log('出错了');
            });
        } else {
            this.downloadLabel.string = "子游戏未下载";
        }

        this.downloadBtn.on('click', () => {
            //下载子游戏/更新子游戏
            this.logand("开始下载")
            SubgameManager.downloadSubgame(name, (progress) => {
                if (isNaN(progress)) {
                    progress = 0;
                }
                this.logand("资源下载中   " + parseInt(progress * 100) + "%")
                this.downloadLabel.string = "资源下载中   " + parseInt(progress * 100) + "%";
            }, function(success) {
                if (success) {
                    SubgameManager.enterSubgame('subgame');
                    this.logand("下载成功")
                } else {
                    cc.log('下载失败');
                }
            });
        }, this);
    },
    logand(c){
        jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity","logconsole","(Ljava/lang/String;)V",c)
    }
});