const { ccclass, property } = cc._decorator;

@ccclass
export default class Main extends cc.Component {
  @property(cc.Camera) camera: cc.Camera = null;
  @property(cc.TiledMap) map: cc.TiledMap = null;

  private _tile: cc.TiledTile = null;
  onLoad() {
    let layer = this.map.getLayers()[0];
    this._tile = layer.getTiledTileAt(9, 14, true);
    this._tile.node.runAction(cc.repeatForever(cc.sequence(
      cc.moveBy(5, cc.v2(0, 300)),
      cc.moveBy(5, cc.v2(0, -300))
    )));
  }

  update(dt: number) {
    this.camera.node.position = this._tile.node.position;
  }
}
