(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/common/Events.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'e2fd280PFtIYq6F+Divbatp', 'Events', __filename);
// common/Events.ts

Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 事件名
 */
var EVENT_NAME;
(function (EVENT_NAME) {
    EVENT_NAME["CHANGE_COLOR"] = "CHANGE_COLOR";
})(EVENT_NAME = exports.EVENT_NAME || (exports.EVENT_NAME = {}));
;
/**
 * 组件类非静态成员函数装饰器，用于预先载入待注册的事件
 * @param event 事件名
 */
function preloadEvent(event) {
    return function (target, funcName, desc) {
        var arr = Events.classMap.get(target.constructor);
        if (arr === undefined) {
            arr = [];
            Events.classMap.set(target.constructor, arr);
        }
        else {
            var find = arr.find(function (e) {
                return e.event === event && e.funcName === funcName;
            });
            if (find) {
                cc.error("event: " + event + " \u91CD\u590D\u8F7D\u5165");
                return;
            }
        }
        arr.push({
            event: event,
            funcName: funcName
        });
    };
}
exports.preloadEvent = preloadEvent;
/**
 * 事件收发管理类
 */
var Events = /** @class */ (function () {
    function Events() {
    }
    /**
     * 注册与target构造函数预先绑定的所有事件
     * @param target 注册目标
     */
    Events.targetOn = function (target) {
        var _this = this;
        var arr = this.classMap.get(target.constructor);
        if (arr) {
            arr.forEach(function (e) {
                _this.on(e.event, target[e.funcName], target);
            });
        }
    };
    /**
     * 注册事件
     * @param event 事件名
     * @param listener 处理事件的监听函数
     * @param target 注册目标
     */
    Events.on = function (event, listener, target) {
        if (!listener || !target) {
            cc.error("event: " + event + " listener\u6216target\u4E0D\u80FD\u4E3A\u7A7A");
            return;
        }
        var map = this._eventsMap.get(event);
        var list = [];
        if (map === undefined) {
            map = new Map();
            map.set(target, list);
            this._eventsMap.set(event, map);
        }
        else {
            list = map.get(target);
            if (list === undefined) {
                list = [];
                map.set(target, list);
            }
            else {
                var result = list.find(function (e) { return e === listener; });
                if (result) {
                    cc.error("event: " + event + " \u91CD\u590D\u6CE8\u518C");
                    return;
                }
            }
        }
        list.push(listener);
    };
    /**
     * 移除事件
     * @param event 事件名
     * @param listener 处理事件的监听函数
     * @param target 注册目标
     */
    Events.off = function (event, listener, target) {
        if (!listener || !target) {
            cc.error("event: " + event + " listener\u6216target\u4E0D\u80FD\u4E3A\u7A7A");
            return;
        }
        var map = this._eventsMap.get(event);
        if (map === undefined) {
            cc.error("event: " + event + " \u672A\u6CE8\u518C\u8BE5\u4E8B\u4EF6");
            return;
        }
        var list = map.get(target);
        if (list === undefined) {
            cc.error("event: " + event + " target\u4E0A\u672A\u6CE8\u518C\u8BE5\u4E8B\u4EF6");
            return;
        }
        var index = list.findIndex(function (e) { return e === listener; });
        if (index < 0) {
            cc.error("event: " + event + " target\u4E0A\u672A\u4EE5\u8BE5listener\u6CE8\u518C\u8BE5\u4E8B\u4EF6");
            return;
        }
        list.splice(index, 1);
        if (list.length <= 0) {
            map.delete(target);
            map.size <= 0 && this._eventsMap.delete(event);
        }
    };
    /**
     * 移除target上注册的所有事件
     * @param target 注册目标
     */
    Events.targetOff = function (target) {
        var _this = this;
        if (!target) {
            cc.error("event: " + event + " target\u4E0D\u80FD\u4E3A\u7A7A");
            return;
        }
        this._eventsMap.forEach(function (map, event) {
            map.delete(target);
            map.size <= 0 && _this._eventsMap.delete(event);
        });
    };
    /**
     * 派发事件
     * @param event 事件名
     * @param arg 事件参数
     */
    Events.emit = function (event, arg) {
        if (arg === void 0) { arg = null; }
        var map = this._eventsMap.get(event);
        if (map === undefined) {
            cc.warn("event: " + event + " \u672A\u6CE8\u518C\u8BE5\u4E8B\u4EF6");
            return;
        }
        map.forEach(function (list, target) {
            list.forEach(function (listener) {
                listener.call(target, arg);
            });
        });
    };
    /**
     * 存储监听事件、监听函数与监听对象
     */
    Events._eventsMap = new Map();
    /**
     * 存储构造函数、监听事件、监听函数名，用于实例化时注册事件
     */
    Events.classMap = new Map();
    return Events;
}());
exports.default = Events;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=Events.js.map
        