window.vLabel = cc.Class({
    extends: cc.Component,

    properties: {
        _fontSize: 30,
        fontSize: {
            get: function () {
                return this._fontSize;
            },
            set: function (size) {
                this._fontSize = size;
                this.refresh();
            }
        },
        _fontColor: cc.Color,
        fontColor: {
            get: function () {
                return this._fontColor;
            },
            set: function (color) {
                this._fontColor = color;
                this.refresh();
            }
        },
        _maxHeight: 0,
        maxHeight: {
            get: function () {
                return this._maxHeight;
            },
            set: function (val) {
                if (val < 0) val = 0;
                this._maxHeight = val;
                this.refresh();
            }
        },
        _string: "",
        string: {
            get: function () {
                return this._string;
            },
            set: function (str) {
                this._string = str;
                this.refresh();
            }
        },
    },
    refresh() {
        //清空NODE。
        this.node.destroyAllChildren();
        this.node.removeAllChildren();

        var totalHeight = 0;
        var str = this._string;
        var zhReg = /[\u4E00-\uFA29]|[\uE7C7-\uE7F3]/;
        for (let i = 0; i < str.length; i++) {
            var node = new cc.Node();
            var lb = node.addComponent(cc.Label);
            lb.string = str[i];
            lb.node.color = this.fontColor;
            lb.fontSize = this.fontSize;
            lb.lineHeight = this.fontSize + 2;
            lb.verticalAlign = cc.macro.TextAlignment.CENTER;
            lb.horizontalAlign = cc.macro.TextAlignment.CENTER;
            lb._updateRenderData(true);
            //检查非中文。
            if (!zhReg.test(str[i])) {
                //外面套一个node，width = height;
                node = new cc.Node();
                node.height = lb.node.width;
                node.width = lb.node.height;
                lb.node.rotation = 90;
                node.addChild(lb.node);
            }
            totalHeight += node.height;

            this.node.addChild(node);
        }

        if (this._maxHeight > 0) {
            if (totalHeight > this._maxHeight) {
                var ph = this._maxHeight / totalHeight;
                this.node.scale = ph;
            }
            else {
                this.node.scale = 1;
            }
        }
    }
});
