cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!',
        startBtn: cc.Node,
    },

    // use this for initialization
    onLoad: function () {
        this.label.string = this.text;

        // 该zip文件，大小约为40M。
        this.dataUrl = 'http://192.168.2.189:8001/remote-assets/tanchuang.zip'

        this._downloader = new jsb.Downloader();
        this._downloader.setOnFileTaskSuccess(this.onSucceed.bind(this));
        this._downloader.setOnTaskProgress(this.onProgress.bind(this));
        this._downloader.setOnTaskError(this.onError.bind(this));
    },

    btnStartDownload: function () {
        this._downloader.createDownloadFileTask(this.dataUrl, jsb.fileUtils.getWritablePath() +  'tanchuang.zip');
        this.label.string = 'start downloading ...'
        this.startBtn.active = false
    },

    onSucceed (task) {
        this.label.string = 'finish'
    },

    onProgress (task, bytesReceived, totalBytesReceived, totalBytesExpected) {
        this.label.string = `${bytesReceived}   ${totalBytesReceived}    ${totalBytesExpected}`
    },

    onError (task, errorCode, errorCodeInternal, errorStr) {
        this.label.string = 'Failed to download file (' + task.requestURL + '): ' + errorStr + '(' + errorCode + ')';
    }, 
});
